/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.webapp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.context.GraniteContext;
import org.granite.messaging.webapp.ApplicationMap;
import org.granite.messaging.webapp.InitialisationMap;
import org.granite.messaging.webapp.SessionMap;

public class ServletGraniteContext
extends GraniteContext {
    private final ServletContext servletContext;
    protected InitialisationMap initialisationMap = null;
    protected ApplicationMap applicationMap = null;
    protected SessionMap sessionMap = null;
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected HttpSession session = null;

    public static ServletGraniteContext createThreadInstance(GraniteConfig graniteConfig, ServicesConfig servicesConfig, ServletContext context, String sessionId, String clientType) {
        ServletGraniteContext graniteContext = new ServletGraniteContext(graniteConfig, servicesConfig, context, sessionId, clientType);
        ServletGraniteContext.setCurrentInstance(graniteContext);
        return graniteContext;
    }

    public static ServletGraniteContext createThreadInstance(GraniteConfig graniteConfig, ServicesConfig servicesConfig, ServletContext context, HttpSession session, String clientType) {
        ServletGraniteContext graniteContext = new ServletGraniteContext(graniteConfig, servicesConfig, context, session, clientType);
        ServletGraniteContext.setCurrentInstance(graniteContext);
        return graniteContext;
    }

    protected ServletGraniteContext(GraniteConfig graniteConfig, ServicesConfig servicesConfig, ServletContext servletContext, String sessionId, String clientType) {
        super(graniteConfig, servicesConfig, sessionId, clientType);
        this.servletContext = servletContext;
    }

    protected ServletGraniteContext(GraniteConfig graniteConfig, ServicesConfig servicesConfig, ServletContext servletContext, HttpSession session, String clientType) {
        super(graniteConfig, servicesConfig, session.getId(), clientType);
        this.servletContext = servletContext;
        this.session = session;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public HttpServletRequest getRequest() {
        if (this.request == null) {
            this.request = new BasicRequest();
        }
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        if (this.response == null) {
            this.response = new BasicResponse();
        }
        return this.response;
    }

    public HttpSession getSession(boolean create) {
        return this.getSession();
    }

    public HttpSession getSession() {
        if (this.session != null) {
            return this.session;
        }
        if (this.getSessionId() == null) {
            return null;
        }
        Map sessionMap = (Map)this.servletContext.getAttribute("org.granite.config.sessionMap");
        return sessionMap != null ? (HttpSession)sessionMap.get(this.getSessionId()) : null;
    }

    @Override
    public Object getSessionLock() {
        return null;
    }

    @Override
    public Map<String, String> getInitialisationMap() {
        if (this.initialisationMap == null) {
            this.initialisationMap = new InitialisationMap(this.servletContext);
        }
        return this.initialisationMap;
    }

    @Override
    public Map<String, Object> getApplicationMap() {
        if (this.applicationMap == null) {
            this.applicationMap = new ApplicationMap(this.servletContext);
        }
        return this.applicationMap;
    }

    @Override
    public Map<String, Object> getSessionMap() {
        return null;
    }

    @Override
    public Map<String, Object> getSessionMap(boolean create) {
        if (this.sessionMap == null && this.getSession() != null) {
            this.sessionMap = new SessionMap(this.getSession());
        }
        return this.sessionMap;
    }

    @Override
    public Map<String, Object> getRequestMap() {
        return null;
    }

    private class BasicResponse
    implements HttpServletResponse {
        private BasicResponse() {
        }

        public void flushBuffer() throws IOException {
        }

        public int getBufferSize() {
            return 0;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public String getContentType() {
            return null;
        }

        public Locale getLocale() {
            return null;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return null;
        }

        public PrintWriter getWriter() throws IOException {
            return null;
        }

        public boolean isCommitted() {
            return false;
        }

        public void reset() {
        }

        public void resetBuffer() {
        }

        public void setBufferSize(int size) {
        }

        public void setCharacterEncoding(String charset) {
        }

        public void setContentLength(int length) {
        }

        public void setContentType(String contentType) {
        }

        public void setLocale(Locale locale) {
        }

        public void addCookie(Cookie cookie) {
        }

        public void addDateHeader(String name, long value) {
        }

        public void addHeader(String name, String value) {
        }

        public void addIntHeader(String name, int value) {
        }

        public boolean containsHeader(String name) {
            return false;
        }

        public String encodeRedirectURL(String url) {
            return null;
        }

        public String encodeRedirectUrl(String url) {
            return null;
        }

        public String encodeURL(String url) {
            return null;
        }

        public String encodeUrl(String url) {
            return null;
        }

        public String getHeader(String name) {
            return null;
        }

        public Collection<String> getHeaderNames() {
            return null;
        }

        public Collection<String> getHeaders(String name) {
            return null;
        }

        public int getStatus() {
            return 0;
        }

        public void sendError(int code) throws IOException {
        }

        public void sendError(int code, String msg) throws IOException {
        }

        public void sendRedirect(String url) throws IOException {
        }

        public void setDateHeader(String name, long value) {
        }

        public void setHeader(String name, String value) {
        }

        public void setIntHeader(String name, int value) {
        }

        public void setStatus(int code) {
        }

        public void setStatus(int code, String msg) {
        }
    }

    private class BasicRequest
    implements HttpServletRequest {
        private Map<String, Object> attributes = new HashMap<String, Object>();

        private BasicRequest() {
        }

        public ServletContext getServletContext() {
            return ServletGraniteContext.this.servletContext;
        }

        public Object getAttribute(String key) {
            return this.attributes.get(key);
        }

        public void removeAttribute(String key) {
            this.attributes.remove(key);
        }

        public void setAttribute(String key, Object value) {
            this.attributes.put(key, value);
        }

        public Enumeration<String> getAttributeNames() {
            return new Hashtable<String, Object>(this.attributes).keys();
        }

        public HttpSession getSession() {
            return ServletGraniteContext.this.getSession();
        }

        public HttpSession getSession(boolean create) {
            return ServletGraniteContext.this.getSession(create);
        }

        public String getRequestedSessionId() {
            return null;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return false;
        }

        public boolean isRequestedSessionIdValid() {
            return false;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isUserInRole(String arg0) {
            return false;
        }

        public void login(String arg0, String arg1) throws ServletException {
        }

        public void logout() throws ServletException {
        }

        public String getCharacterEncoding() {
            return null;
        }

        public int getContentLength() {
            return 0;
        }

        public String getContentType() {
            return null;
        }

        public DispatcherType getDispatcherType() {
            return null;
        }

        public ServletInputStream getInputStream() throws IOException {
            return null;
        }

        public String getLocalAddr() {
            return null;
        }

        public String getLocalName() {
            return null;
        }

        public int getLocalPort() {
            return 0;
        }

        public Locale getLocale() {
            return null;
        }

        public Enumeration<Locale> getLocales() {
            return null;
        }

        public String getParameter(String arg0) {
            return null;
        }

        public Map<String, String[]> getParameterMap() {
            return null;
        }

        public Enumeration<String> getParameterNames() {
            return null;
        }

        public String[] getParameterValues(String arg0) {
            return null;
        }

        public String getProtocol() {
            return null;
        }

        public BufferedReader getReader() throws IOException {
            return null;
        }

        public String getRealPath(String arg0) {
            return null;
        }

        public String getRemoteAddr() {
            return null;
        }

        public String getRemoteHost() {
            return null;
        }

        public int getRemotePort() {
            return 0;
        }

        public RequestDispatcher getRequestDispatcher(String arg0) {
            return null;
        }

        public String getScheme() {
            return null;
        }

        public String getServerName() {
            return null;
        }

        public int getServerPort() {
            return 0;
        }

        public AsyncContext getAsyncContext() {
            return null;
        }

        public boolean isAsyncStarted() {
            return false;
        }

        public boolean isAsyncSupported() {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        }

        public AsyncContext startAsync() throws IllegalStateException {
            return null;
        }

        public AsyncContext startAsync(ServletRequest request, ServletResponse response) throws IllegalStateException {
            return null;
        }

        public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
            return false;
        }

        public String getAuthType() {
            return null;
        }

        public String getContextPath() {
            return null;
        }

        public Cookie[] getCookies() {
            return null;
        }

        public long getDateHeader(String name) {
            return 0L;
        }

        public String getHeader(String name) {
            return null;
        }

        public Enumeration<String> getHeaderNames() {
            return null;
        }

        public Enumeration<String> getHeaders(String name) {
            return null;
        }

        public int getIntHeader(String name) {
            return 0;
        }

        public String getMethod() {
            return null;
        }

        public Part getPart(String name) throws IOException, ServletException {
            return null;
        }

        public Collection<Part> getParts() throws IOException, ServletException {
            return null;
        }

        public String getPathInfo() {
            return null;
        }

        public String getPathTranslated() {
            return null;
        }

        public String getQueryString() {
            return null;
        }

        public String getRemoteUser() {
            return null;
        }

        public String getRequestURI() {
            return null;
        }

        public StringBuffer getRequestURL() {
            return null;
        }

        public String getServletPath() {
            return null;
        }
    }
}

