/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.config.GraniteConfigListener;
import org.granite.context.GraniteContext;
import org.granite.gravity.AbstractGravityServlet;
import org.granite.gravity.GravityInternal;
import org.granite.gravity.GravityManager;
import org.granite.messaging.jmf.JMFDeserializer;
import org.granite.messaging.jmf.JMFSerializer;
import org.granite.messaging.webapp.HttpGraniteContext;
import org.granite.util.ContentType;
import org.granite.util.UUIDUtil;

public class GravityServletUtil {
    public static final String CONNECT_MESSAGE_KEY = AbstractGravityServlet.class.getName() + ".CONNECT_MESSAGE";

    public static void init(ServletConfig config) throws ServletException {
        GravityManager.start(config);
    }

    public static void setConnectMessage(HttpServletRequest request, Message connect) {
        if (!(connect instanceof CommandMessage) && ((CommandMessage)connect).getOperation() != 20) {
            throw new IllegalArgumentException("Not a connect message: " + connect);
        }
        request.setAttribute(CONNECT_MESSAGE_KEY, (Object)connect);
    }

    public static CommandMessage getConnectMessage(HttpServletRequest request) {
        return (CommandMessage)request.getAttribute(CONNECT_MESSAGE_KEY);
    }

    public static void removeConnectMessage(HttpServletRequest request) {
        request.removeAttribute(CONNECT_MESSAGE_KEY);
    }

    public static long getLongPollingTimeout(ServletContext context) {
        return GravityManager.getGravity(context).getGravityConfig().getLongPollingTimeoutMillis();
    }

    public static GravityInternal initializeRequest(ServletConfig config, GravityInternal gravity, HttpServletRequest request, HttpServletResponse response) {
        HttpGraniteContext.createThreadIntance(gravity.getGraniteConfig(), gravity.getServicesConfig(), config.getServletContext(), request, response);
        return gravity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Message[] deserialize(GravityInternal gravity, HttpServletRequest request) throws ClassNotFoundException, IOException {
        ServletInputStream is = request.getInputStream();
        try {
            Message[] messageArray = GravityServletUtil.deserialize(gravity, request, (InputStream)request.getInputStream());
            return messageArray;
        }
        finally {
            is.close();
        }
    }

    public static Message[] deserialize(GravityInternal gravity, HttpServletRequest request, InputStream is) throws ClassNotFoundException, IOException {
        if (ContentType.JMF_AMF.mimeType().equals(request.getContentType())) {
            JMFDeserializer deserializer = new JMFDeserializer(is, gravity.getGraniteConfig().getSharedContext());
            return (Message[])deserializer.readObject();
        }
        ObjectInput amf3Deserializer = gravity.getGraniteConfig().newAMF3Deserializer(is);
        Object[] objects = (Object[])amf3Deserializer.readObject();
        Message[] messages = new Message[objects.length];
        System.arraycopy(objects, 0, messages, 0, objects.length);
        return messages;
    }

    public static ObjectOutput newSerializer(GravityInternal gravity, OutputStream os, ContentType contentType) throws ServletException, IOException {
        if (contentType == ContentType.JMF_AMF) {
            return new JMFSerializer(os, gravity.getGraniteConfig().getSharedContext());
        }
        return gravity.getGraniteConfig().newAMF3Serializer(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(GravityInternal gravity, HttpServletResponse response, Message[] messages, ContentType contentType) throws ServletException, IOException {
        if (contentType == ContentType.JMF_AMF && gravity.getGraniteConfig().getSharedContext() == null) {
            throw GraniteConfigListener.newSharedContextNotInitializedException();
        }
        OutputStream os = null;
        try {
            String dsId = null;
            for (Message message : messages) {
                if (!"nil".equals(message.getHeader("DSId"))) continue;
                if (dsId == null) {
                    dsId = UUIDUtil.randomUUID();
                }
                message.getHeaders().put("DSId", dsId);
            }
            response.setStatus(200);
            response.setContentType(contentType.mimeType());
            response.setDateHeader("Expire", 0L);
            response.setHeader("Cache-Control", "no-store");
            os = response.getOutputStream();
            ObjectOutput serializer = GravityServletUtil.newSerializer(gravity, os, contentType);
            serializer.writeObject(messages);
            serializer.flush();
            os.flush();
            response.flushBuffer();
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    public static void cleanupRequest(HttpServletRequest request) {
        GraniteContext.release();
    }
}

