/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.gravity.Channel;
import org.granite.gravity.MessageReceivingException;
import org.granite.gravity.selector.GravityMessageSelector;
import org.granite.gravity.selector.MessageSelector;
import org.granite.logging.Logger;
import org.granite.util.TypeUtil;

public class Subscription
implements Serializable {
    private static final long serialVersionUID = -8527072003319223252L;
    private static final Logger log = Logger.getLogger(Subscription.class);
    private final Channel channel;
    private final String destination;
    private final String subTopicId;
    private final String subscriptionId;
    private String selectorText;
    private String selectorClassName;
    private transient Constructor<?> messageSelectorConstructor;
    private transient MessageSelector selector;
    private final boolean noLocal;

    public Subscription(Channel channel, String destination, String subTopicId, String subscriptionId, boolean noLocal) {
        this.channel = channel;
        this.destination = destination;
        this.subTopicId = subTopicId;
        this.subscriptionId = subscriptionId;
        this.noLocal = noLocal;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.selectorClassName != null) {
            try {
                this.messageSelectorConstructor = TypeUtil.getConstructor(this.selectorClassName, new Class[]{String.class});
            }
            catch (NoSuchMethodException e) {
                throw new IOException("Could not get message selector: " + this.selectorClassName);
            }
        }
        this.parseSelector();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getSubTopicId() {
        return this.subTopicId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSelector(String selector) {
        this.selectorText = selector;
        this.parseSelector();
    }

    private void parseSelector() {
        if (this.selectorText != null) {
            try {
                Constructor<?> messageSelectorConstructor = this.messageSelectorConstructor;
                if (messageSelectorConstructor == null) {
                    GraniteContext context = GraniteContext.getCurrentInstance();
                    if (context == null) {
                        throw new IllegalStateException("Cannot parse selector outside of GDS context");
                    }
                    messageSelectorConstructor = ((GraniteConfig)context.getGraniteConfig()).getMessageSelectorConstructor();
                }
                this.selector = messageSelectorConstructor == null ? new GravityMessageSelector(this.selectorText) : (MessageSelector)messageSelectorConstructor.newInstance(this.selectorText);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create message selector", e);
            }
        }
    }

    public boolean accept(Channel fromClient, AsyncMessage message) {
        if (this.noLocal && message.getClientId().equals(this.channel.getId())) {
            return false;
        }
        return this.selector == null || this.selector.accept(message);
    }

    public boolean deliver(Channel fromClient, AsyncMessage message) {
        if (!this.accept(fromClient, message)) {
            return false;
        }
        try {
            message.setHeader("DSDstClientId", this.subscriptionId);
            log.debug("Channel %s deliver message to subscription %s", this.channel.getId(), this.subscriptionId);
            this.getChannel().receive(message);
            return true;
        }
        catch (MessageReceivingException e) {
            log.error(e, "Could not deliver message", new Object[0]);
            return false;
        }
    }

    public Message getUnsubscribeMessage() {
        CommandMessage unsubscribeMessage = new CommandMessage();
        unsubscribeMessage.setOperation(1);
        unsubscribeMessage.setClientId(this.getChannel().getId());
        unsubscribeMessage.setDestination(this.destination);
        unsubscribeMessage.setHeader("DSSubtopic", this.getSubTopicId());
        unsubscribeMessage.setHeader("DSDstClientId", this.getSubscriptionId());
        return unsubscribeMessage;
    }

    public boolean equals(Object o) {
        if (!o.getClass().equals(Subscription.class)) {
            return false;
        }
        Subscription s = (Subscription)o;
        return this.getChannel().equals(s.getChannel()) && this.getSubscriptionId().equals(s.getSubscriptionId());
    }

    public String toString() {
        return this.subscriptionId + ":" + this.subTopicId;
    }
}

