/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity.adapters;

import flex.messaging.messages.AcknowledgeMessage;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.granite.clustering.DistributedDataFactory;
import org.granite.clustering.TransientReference;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.gravity.Channel;
import org.granite.gravity.MessageReceivingException;
import org.granite.gravity.adapters.JMSClient;
import org.granite.gravity.adapters.ServiceAdapter;
import org.granite.logging.Logger;
import org.granite.messaging.amf.io.AMF3Deserializer;
import org.granite.messaging.amf.io.AMF3Serializer;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.webapp.ServletGraniteContext;
import org.granite.util.XMap;

public class JMSServiceAdapter
extends ServiceAdapter {
    private static final Logger log = Logger.getLogger(JMSServiceAdapter.class);
    public static final long DEFAULT_FAILOVER_RETRY_INTERVAL = 1000L;
    public static final long DEFAULT_RECONNECT_RETRY_INTERVAL = 20000L;
    public static final int DEFAULT_FAILOVER_RETRY_COUNT = 4;
    protected ConnectionFactory jmsConnectionFactory = null;
    protected Destination jmsDestination = null;
    protected ConcurrentMap<String, JMSClient> jmsClients = new ConcurrentHashMap<String, JMSClient>();
    protected String destinationName = null;
    protected boolean textMessages = false;
    protected boolean transactedSessions = false;
    protected int acknowledgeMode = 1;
    protected int messagePriority = 4;
    protected int deliveryMode = 2;
    protected boolean noLocal = false;
    protected boolean sessionSelector = false;
    protected long failoverRetryInterval = 1000L;
    protected int failoverRetryCount = 4;
    protected long reconnectRetryInterval = 20000L;

    @Override
    public void configure(XMap adapterProperties, XMap destinationProperties) throws ServiceException {
        String ackMode;
        super.configure(adapterProperties, destinationProperties);
        log.info("Using JMS configuration: %s", destinationProperties.getOne("jms"));
        this.destinationName = destinationProperties.get("jms/destination-name");
        if (Boolean.TRUE.toString().equals(destinationProperties.get("jms/transacted-sessions"))) {
            this.transactedSessions = true;
        }
        if ("AUTO_ACKNOWLEDGE".equals(ackMode = destinationProperties.get("jms/acknowledge-mode"))) {
            this.acknowledgeMode = 1;
        } else if ("CLIENT_ACKNOWLEDGE".equals(ackMode)) {
            this.acknowledgeMode = 2;
        } else if ("DUPS_OK_ACKNOWLEDGE".equals(ackMode)) {
            this.acknowledgeMode = 3;
        } else if (ackMode != null) {
            log.warn("Unsupported acknowledge mode: %s (using default AUTO_ACKNOWLEDGE)", ackMode);
        }
        if ("javax.jms.TextMessage".equals(destinationProperties.get("jms/message-type"))) {
            this.textMessages = true;
        }
        if (Boolean.TRUE.toString().equals(destinationProperties.get("jms/no-local"))) {
            this.noLocal = true;
        }
        if (Boolean.TRUE.toString().equals(destinationProperties.get("session-selector"))) {
            this.sessionSelector = true;
        }
        this.failoverRetryInterval = destinationProperties.get("jms/failover-retry-interval", Long.TYPE, 1000L);
        if (this.failoverRetryInterval <= 0L) {
            log.warn("Illegal failover retry interval: %d (using default %d)", this.failoverRetryInterval, 1000L);
            this.failoverRetryInterval = 1000L;
        }
        this.failoverRetryCount = destinationProperties.get("jms/failover-retry-count", Integer.TYPE, 4);
        if (this.failoverRetryCount <= 0) {
            log.warn("Illegal failover retry count: %s (using default %d)", this.failoverRetryCount, 4);
            this.failoverRetryCount = 4;
        }
        this.reconnectRetryInterval = destinationProperties.get("jms/reconnect-retry-interval", Long.TYPE, 20000L);
        if (this.reconnectRetryInterval <= 0L) {
            log.warn("Illegal reconnect retry interval: %d (using default %d)", this.reconnectRetryInterval, 20000L);
            this.reconnectRetryInterval = 20000L;
        }
        Properties environment = new Properties();
        for (XMap property : destinationProperties.getAll("jms/initial-context-environment/property")) {
            String name = property.get("name");
            String value = property.get("value");
            if ("Context.PROVIDER_URL".equals(name)) {
                environment.put("java.naming.provider.url", value);
                continue;
            }
            if ("Context.INITIAL_CONTEXT_FACTORY".equals(name)) {
                environment.put("java.naming.factory.initial", value);
                continue;
            }
            if ("Context.URL_PKG_PREFIXES".equals(name)) {
                environment.put("java.naming.factory.url.pkgs", value);
                continue;
            }
            if ("Context.SECURITY_PRINCIPAL".equals(name)) {
                environment.put("java.naming.security.principal", value);
                continue;
            }
            if ("Context.SECURITY_CREDENTIALS".equals(name)) {
                environment.put("java.naming.security.credentials", value);
                continue;
            }
            log.warn("Unknown InitialContext property: %s (ignored)", name);
        }
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext(environment.size() > 0 ? environment : null);
        }
        catch (NamingException e) {
            log.error(e, "Could not initialize JNDI context", new Object[0]);
            throw new ServiceException("Error configuring JMS Adapter", e);
        }
        String cfJndiName = destinationProperties.get("jms/connection-factory");
        try {
            this.jmsConnectionFactory = (ConnectionFactory)initialContext.lookup(cfJndiName);
        }
        catch (NamingException e) {
            log.error(e, "Could not find JMS ConnectionFactory named %s in JNDI", cfJndiName);
            throw new ServiceException("Error configuring JMS Adapter", e);
        }
        String dsJndiName = destinationProperties.get("jms/destination-jndi-name");
        try {
            this.jmsDestination = (Destination)initialContext.lookup(dsJndiName);
        }
        catch (NamingException e) {
            log.error(e, "Could not find JMS destination named %s in JNDI", dsJndiName);
            throw new ServiceException("Error configuring JMS Adapter", e);
        }
    }

    protected Destination getProducerDestination(String topic) {
        return this.jmsDestination;
    }

    protected Destination getConsumerDestination(String topic) {
        return this.jmsDestination;
    }

    @Override
    public void start() throws ServiceException {
        super.start();
    }

    @Override
    public void stop() throws ServiceException {
        super.stop();
        for (JMSClient jmsClient : this.jmsClients.values()) {
            try {
                jmsClient.close();
            }
            catch (Exception e) {
                log.warn(e, "Could not close JMSClient: %s", jmsClient);
            }
        }
        this.jmsClients.clear();
    }

    private synchronized JMSClient connectJMSClient(Channel client, String destination) throws Exception {
        JMSClient jmsClient = (JMSClient)this.jmsClients.get(client.getId());
        if (jmsClient == null) {
            jmsClient = new JMSClientImpl(client);
            jmsClient.connect();
            this.jmsClients.put(client.getId(), jmsClient);
            if (this.sessionSelector && GraniteContext.getCurrentInstance() instanceof ServletGraniteContext) {
                ((ServletGraniteContext)GraniteContext.getCurrentInstance()).getSessionMap().put("org.granite.gravity.jmsClient." + destination, jmsClient);
            }
            log.debug("JMS client connected for channel " + client.getId(), new Object[0]);
        }
        return jmsClient;
    }

    private synchronized void closeJMSClientIfNecessary(Channel channel, String destination) throws Exception {
        JMSClient jmsClient = (JMSClient)this.jmsClients.get(channel.getId());
        if (jmsClient != null && !jmsClient.hasActiveConsumer()) {
            jmsClient.close();
            this.jmsClients.remove(channel.getId());
            if (this.sessionSelector && GraniteContext.getCurrentInstance() instanceof ServletGraniteContext) {
                ((ServletGraniteContext)GraniteContext.getCurrentInstance()).getSessionMap().remove("org.granite.gravity.jmsClient." + destination);
            }
            log.debug("JMS client closed for channel " + channel.getId(), new Object[0]);
        }
    }

    @Override
    public Object invoke(Channel fromClient, AsyncMessage message) {
        String topicId = (String)message.getHeader("DSSubtopic");
        if (this.getSecurityPolicy().canPublish(fromClient, topicId, message)) {
            try {
                JMSClient jmsClient = this.connectJMSClient(fromClient, message.getDestination());
                jmsClient.send(message);
                AcknowledgeMessage reply = new AcknowledgeMessage(message);
                reply.setMessageId(message.getMessageId());
                return reply;
            }
            catch (Exception e) {
                log.error(e, "Error sending message", new Object[0]);
                ErrorMessage error = new ErrorMessage((Message)message, null);
                error.setFaultString("JMS Adapter error " + e.getMessage());
                return error;
            }
        }
        log.debug("Channel %s tried to publish a message to topic %s", fromClient, topicId);
        ErrorMessage error = new ErrorMessage((Message)message, null);
        error.setFaultString("Server.Publish.Denied");
        return error;
    }

    @Override
    public Object manage(Channel fromChannel, CommandMessage message) {
        String topicId = (String)message.getHeader("DSSubtopic");
        if (message.getOperation() == 0) {
            if (this.getSecurityPolicy().canSubscribe(fromChannel, topicId, message)) {
                try {
                    JMSClient jmsClient = this.connectJMSClient(fromChannel, message.getDestination());
                    jmsClient.subscribe(message);
                    AcknowledgeMessage reply = new AcknowledgeMessage(message);
                    return reply;
                }
                catch (Exception e) {
                    throw new RuntimeException("JMSAdapter subscribe error on topic: " + message, e);
                }
            }
            log.debug("Channel %s tried to subscribe to topic %s", fromChannel, topicId);
            ErrorMessage error = new ErrorMessage((Message)message, null);
            error.setFaultString("Server.Subscribe.Denied");
            return error;
        }
        if (message.getOperation() == 1) {
            try {
                JMSClient jmsClient = this.connectJMSClient(fromChannel, message.getDestination());
                jmsClient.unsubscribe(message);
                this.closeJMSClientIfNecessary(fromChannel, message.getDestination());
                AcknowledgeMessage reply = new AcknowledgeMessage(message);
                return reply;
            }
            catch (Exception e) {
                throw new RuntimeException("JMSAdapter unsubscribe error on topic: " + message, e);
            }
        }
        return null;
    }

    @TransientReference
    private class JMSClientImpl
    implements JMSClient {
        private Channel channel = null;
        private String topic = null;
        private Connection jmsConnection = null;
        private Session jmsProducerSession = null;
        private MessageProducer jmsProducer = null;
        private Map<String, JMSConsumer> consumers = new HashMap<String, JMSConsumer>();
        private boolean useGlassFishNoExceptionListenerWorkaround = false;
        private boolean useGlassFishNoCommitWorkaround = false;
        private ExceptionListener connectionExceptionListener = new ConnectionExceptionListener();

        public JMSClientImpl(Channel channel) {
            this.channel = channel;
        }

        @Override
        public boolean hasActiveConsumer() {
            return this.consumers != null && !this.consumers.isEmpty();
        }

        @Override
        public void connect() throws ServiceException {
            if (this.jmsConnection != null) {
                return;
            }
            try {
                this.jmsConnection = JMSServiceAdapter.this.jmsConnectionFactory.createConnection();
                if (!this.useGlassFishNoExceptionListenerWorkaround) {
                    try {
                        this.jmsConnection.setExceptionListener(this.connectionExceptionListener);
                    }
                    catch (JMSException e) {
                        if (e.getMessage().startsWith("MQJMSRA_DC2001: Unsupported:setExceptionListener()")) {
                            this.useGlassFishNoExceptionListenerWorkaround = true;
                        }
                        throw e;
                    }
                }
                this.jmsConnection.start();
                log.debug("JMS client connected for channel " + this.channel.getId(), new Object[0]);
            }
            catch (JMSException e) {
                throw new ServiceException("JMS Initialize error", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void close() throws ServiceException {
            try {
                if (this.jmsProducer != null) {
                    this.jmsProducer.close();
                }
            }
            catch (JMSException e) {
                log.error(e, "Could not close JMS Producer for channel " + this.channel.getId(), new Object[0]);
            }
            finally {
                try {
                    if (this.jmsProducerSession != null) {
                        this.jmsProducerSession.close();
                    }
                }
                catch (JMSException e) {
                    log.error(e, "Could not close JMS Producer Session for channel " + this.channel.getId(), new Object[0]);
                }
            }
            for (JMSConsumer consumer : this.consumers.values()) {
                try {
                    consumer.close();
                }
                catch (JMSException e) {
                    log.error(e, "Could not close JMS Consumer " + consumer.subscriptionId + " for channel " + this.channel.getId(), new Object[0]);
                }
            }
            try {
                this.jmsConnection.stop();
                return;
            }
            catch (JMSException e) {
                log.debug(e, "Could not stop JMS Connection for channel " + this.channel.getId(), new Object[0]);
                return;
            }
            finally {
                try {
                    this.jmsConnection.close();
                }
                catch (JMSException e) {
                    throw new ServiceException("JMS Stop error", e);
                }
                finally {
                    this.consumers.clear();
                }
            }
        }

        private void createProducer(String topic) throws Exception {
            try {
                int retryCount = JMSServiceAdapter.this.failoverRetryCount;
                while (true) {
                    try {
                        this.jmsProducer = this.jmsProducerSession.createProducer(JMSServiceAdapter.this.getProducerDestination(topic != null ? topic : this.topic));
                        if (retryCount >= JMSServiceAdapter.this.failoverRetryCount) break;
                        this.jmsProducerSession.recover();
                    }
                    catch (Exception e) {
                        if (retryCount <= 0) {
                            throw e;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug(e, "Could not create JMS Producer (retrying %d time)", retryCount);
                        } else {
                            log.info("Could not create JMS Producer (retrying %d time)", retryCount);
                        }
                        try {
                            Thread.sleep(JMSServiceAdapter.this.failoverRetryInterval);
                            continue;
                        }
                        catch (Exception f) {
                            throw new ServiceException("Could not sleep when retrying to create JMS Producer", f.getMessage(), e);
                        }
                        if (retryCount-- > 0) continue;
                    }
                    break;
                }
                this.jmsProducer.setPriority(JMSServiceAdapter.this.messagePriority);
                this.jmsProducer.setDeliveryMode(JMSServiceAdapter.this.deliveryMode);
                log.debug("Created JMS Producer for channel %s", this.channel.getId());
            }
            catch (JMSException e) {
                this.jmsProducerSession.close();
                this.jmsProducerSession = null;
                throw e;
            }
        }

        @Override
        public void send(AsyncMessage message) throws Exception {
            Object msg = null;
            if (Boolean.TRUE.equals(message.getHeader("GDS_BYTEARRAY_BODY"))) {
                byte[] byteArray = (byte[])message.getBody();
                ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
                AMF3Deserializer deser = new AMF3Deserializer(bais);
                msg = deser.readObject();
                deser.close();
            } else {
                msg = message.getBody();
            }
            this.internalSend(message.getHeaders(), msg, message.getMessageId(), message.getCorrelationId(), message.getTimestamp(), message.getTimeToLive());
        }

        @Override
        public void send(Map<String, Object> params, Object msg, long timeToLive) throws Exception {
            this.internalSend(params, msg, null, null, new Date().getTime(), timeToLive);
        }

        public void internalSend(Map<String, Object> headers, Object msg, String messageId, String correlationId, long timestamp, long timeToLive) throws Exception {
            String topic = (String)headers.get("DSSubtopic");
            if (this.jmsProducerSession == null) {
                this.jmsProducerSession = this.jmsConnection.createSession(JMSServiceAdapter.this.transactedSessions, JMSServiceAdapter.this.acknowledgeMode);
                log.debug("Created JMS Producer Session for channel %s (transacted: %s, ack: %s)", this.channel.getId(), JMSServiceAdapter.this.transactedSessions, JMSServiceAdapter.this.acknowledgeMode);
            }
            if (this.jmsProducer == null) {
                this.createProducer(topic);
            }
            Object jmsMessage = null;
            jmsMessage = JMSServiceAdapter.this.textMessages ? this.jmsProducerSession.createTextMessage(msg.toString()) : this.jmsProducerSession.createObjectMessage((Serializable)msg);
            jmsMessage.setJMSMessageID(this.normalizeJMSMessageID(messageId));
            jmsMessage.setJMSCorrelationID(this.normalizeJMSMessageID(correlationId));
            jmsMessage.setJMSTimestamp(timestamp);
            jmsMessage.setJMSExpiration(timeToLive);
            for (Map.Entry<String, Object> me : headers.entrySet()) {
                if ("JMSType".equals(me.getKey())) {
                    if (!(me.getValue() instanceof String)) continue;
                    jmsMessage.setJMSType((String)me.getValue());
                    continue;
                }
                if ("JMSPriority".equals(me.getKey())) {
                    if (!(me.getValue() instanceof Integer)) continue;
                    jmsMessage.setJMSPriority(((Integer)me.getValue()).intValue());
                    continue;
                }
                jmsMessage.setObjectProperty(me.getKey(), me.getValue());
            }
            this.jmsProducer.send((javax.jms.Message)jmsMessage);
            if (JMSServiceAdapter.this.transactedSessions && !this.useGlassFishNoCommitWorkaround) {
                try {
                    this.jmsProducerSession.commit();
                }
                catch (JMSException e) {
                    if (e.getMessage() != null && e.getMessage().startsWith("MQJMSRA_DS4001")) {
                        this.useGlassFishNoCommitWorkaround = true;
                    }
                    log.error(e, "Could not commit JMS Session for channel %s", this.channel.getId());
                }
            }
        }

        private String normalizeJMSMessageID(String messageId) {
            if (messageId != null && !messageId.startsWith("ID:")) {
                messageId = "ID:" + messageId;
            }
            return messageId;
        }

        @Override
        public void subscribe(CommandMessage message) throws Exception {
            String subscriptionId = (String)message.getHeader("DSDstClientId");
            String selector = (String)message.getHeader("DSSelector");
            this.topic = (String)message.getHeader("DSSubtopic");
            this.internalSubscribe(subscriptionId, selector, message.getDestination(), this.topic);
        }

        @Override
        public void subscribe(String selector, String destination, String topic) throws Exception {
            GraniteConfig graniteConfig = (GraniteConfig)GraniteContext.getCurrentInstance().getGraniteConfig();
            DistributedDataFactory distributedDataFactory = graniteConfig.getDistributedDataFactory();
            String subscriptionId = distributedDataFactory.getInstance().getDestinationSubscriptionId(destination);
            if (subscriptionId != null) {
                this.internalSubscribe(subscriptionId, selector, destination, topic);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalSubscribe(String subscriptionId, String selector, String destination, String topic) throws Exception {
            Map<String, JMSConsumer> map = this.consumers;
            synchronized (map) {
                JMSConsumer consumer = this.consumers.get(subscriptionId);
                if (consumer == null) {
                    consumer = new JMSConsumer(subscriptionId, selector, JMSServiceAdapter.this.noLocal);
                    consumer.connect(selector);
                    this.consumers.put(subscriptionId, consumer);
                } else {
                    consumer.setSelector(selector);
                }
                this.channel.addSubscription(destination, topic, subscriptionId, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unsubscribe(CommandMessage message) throws Exception {
            String subscriptionId = (String)message.getHeader("DSDstClientId");
            Map<String, JMSConsumer> map = this.consumers;
            synchronized (map) {
                JMSConsumer consumer = this.consumers.get(subscriptionId);
                try {
                    if (consumer != null) {
                        consumer.close();
                    }
                }
                finally {
                    this.consumers.remove(subscriptionId);
                    this.channel.removeSubscription(subscriptionId);
                }
            }
        }

        private class JMSConsumer
        implements MessageListener {
            private String subscriptionId = null;
            private Session jmsConsumerSession = null;
            private MessageConsumer jmsConsumer = null;
            private boolean noLocal = false;
            private String selector = null;
            private boolean useJBossTCCLDeserializationWorkaround = false;
            private boolean useGlassFishNoCommitWorkaround = false;
            private boolean reconnected = false;
            private Timer reconnectTimer = null;

            public JMSConsumer(String subscriptionId, String selector, boolean noLocal) throws Exception {
                this.subscriptionId = subscriptionId;
                this.noLocal = noLocal;
                this.selector = selector;
            }

            public void connect(String selector) throws Exception {
                if (this.jmsConsumer != null) {
                    return;
                }
                this.selector = selector;
                JMSClientImpl.this.connect();
                if (this.jmsConsumerSession == null) {
                    this.jmsConsumerSession = JMSClientImpl.this.jmsConnection.createSession(JMSServiceAdapter.this.transactedSessions, JMSServiceAdapter.this.acknowledgeMode);
                    if (this.reconnected) {
                        this.jmsConsumerSession.recover();
                    }
                    log.debug("Created JMS Consumer Session for channel %s (transacted: %s, ack: %s)", JMSClientImpl.this.channel.getId(), JMSServiceAdapter.this.transactedSessions, JMSServiceAdapter.this.acknowledgeMode);
                }
                if (this.reconnectTimer != null) {
                    this.reconnectTimer.cancel();
                }
                try {
                    int retryCount = JMSServiceAdapter.this.failoverRetryCount;
                    while (true) {
                        try {
                            this.jmsConsumer = this.jmsConsumerSession.createConsumer(JMSServiceAdapter.this.getConsumerDestination(JMSClientImpl.this.topic), selector, this.noLocal);
                            if (retryCount >= JMSServiceAdapter.this.failoverRetryCount) break;
                            this.reconnected = true;
                        }
                        catch (Exception e) {
                            if (retryCount <= 0) {
                                throw e;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug(e, "Could not create JMS Consumer (retrying %d time)", retryCount);
                            } else {
                                log.info("Could not create JMS Consumer (retrying %d time)", retryCount);
                            }
                            try {
                                Thread.sleep(JMSServiceAdapter.this.failoverRetryInterval);
                                continue;
                            }
                            catch (Exception f) {
                                throw new ServiceException("Could not sleep when retrying to create JMS Consumer", f.getMessage(), e);
                            }
                            if (retryCount-- > 0) continue;
                        }
                        break;
                    }
                    this.jmsConsumer.setMessageListener((MessageListener)this);
                    log.debug("Created JMS Consumer for channel %s", JMSClientImpl.this.channel.getId());
                }
                catch (Exception e) {
                    this.close();
                    throw e;
                }
            }

            public void setSelector(String selector) throws Exception {
                if (this.jmsConsumer != null) {
                    this.jmsConsumer.close();
                    this.jmsConsumer = null;
                }
                this.connect(selector);
                log.debug("Changed selector to %s for JMS Consumer of channel %s", selector, JMSClientImpl.this.channel.getId());
            }

            public void reset() {
                this.jmsConsumer = null;
                this.jmsConsumerSession = null;
                TimerTask reconnectTask = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            JMSConsumer.this.connect(JMSConsumer.this.selector);
                            JMSConsumer.this.reconnectTimer.cancel();
                            JMSConsumer.this.reconnectTimer = null;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                if (this.reconnectTimer != null) {
                    this.reconnectTimer.cancel();
                }
                this.reconnectTimer = new Timer();
                this.reconnectTimer.schedule(reconnectTask, JMSServiceAdapter.this.failoverRetryInterval, JMSServiceAdapter.this.reconnectRetryInterval);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws JMSException {
                if (this.reconnectTimer != null) {
                    this.reconnectTimer.cancel();
                }
                try {
                    if (this.jmsConsumer != null) {
                        this.jmsConsumer.close();
                        this.jmsConsumer = null;
                    }
                }
                finally {
                    if (this.jmsConsumerSession != null) {
                        this.jmsConsumerSession.close();
                        this.jmsConsumerSession = null;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(javax.jms.Message message) {
                if (!(message instanceof ObjectMessage) && !(message instanceof TextMessage)) {
                    log.error("JMS Adapter message type not allowed: %s", message.getClass().getName());
                    try {
                        if (JMSServiceAdapter.this.acknowledgeMode == 2) {
                            message.acknowledge();
                        }
                        if (JMSServiceAdapter.this.transactedSessions) {
                            this.jmsConsumerSession.commit();
                        }
                    }
                    catch (JMSException e) {
                        log.error(e, "Could not ack/commit JMS onMessage", new Object[0]);
                    }
                }
                log.debug("Delivering JMS message to channel %s subscription %s", JMSClientImpl.this.channel.getId(), this.subscriptionId);
                AsyncMessage dmsg = new AsyncMessage();
                try {
                    TextMessage jmsMessage;
                    Object msg = null;
                    if (JMSServiceAdapter.this.textMessages) {
                        jmsMessage = (TextMessage)message;
                        msg = jmsMessage.getText();
                    } else {
                        jmsMessage = (ObjectMessage)message;
                        if (this.useJBossTCCLDeserializationWorkaround) {
                            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(JMSServiceAdapter.this.getClass().getClassLoader());
                                msg = jmsMessage.getObject();
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(contextClassLoader);
                            }
                        }
                        try {
                            msg = jmsMessage.getObject();
                        }
                        catch (JMSException e) {
                            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(JMSServiceAdapter.this.getClass().getClassLoader());
                                msg = jmsMessage.getObject();
                                this.useJBossTCCLDeserializationWorkaround = true;
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(contextClassLoader);
                            }
                        }
                    }
                    dmsg.setDestination(JMSServiceAdapter.this.getDestination().getId());
                    if (Boolean.TRUE.equals(message.getBooleanProperty("GDS_BYTEARRAY_BODY"))) {
                        JMSServiceAdapter.this.getGravity().initThread(null, JMSClientImpl.this.channel.getClientType());
                        try {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
                            AMF3Serializer ser = new AMF3Serializer(baos);
                            ser.writeObject(msg);
                            ser.close();
                            baos.close();
                            dmsg.setBody(baos.toByteArray());
                        }
                        finally {
                            JMSServiceAdapter.this.getGravity().releaseThread();
                        }
                    } else {
                        dmsg.setBody(msg);
                    }
                    dmsg.setMessageId(this.denormalizeJMSMessageID(message.getJMSMessageID()));
                    dmsg.setCorrelationId(this.denormalizeJMSMessageID(message.getJMSCorrelationID()));
                    dmsg.setTimestamp(message.getJMSTimestamp());
                    dmsg.setTimeToLive(message.getJMSExpiration());
                    Enumeration ename = message.getPropertyNames();
                    while (ename.hasMoreElements()) {
                        String pname = (String)ename.nextElement();
                        dmsg.setHeader(pname, message.getObjectProperty(pname));
                    }
                    dmsg.setHeader("JMSType", message.getJMSType());
                    dmsg.setHeader("JMSPriority", message.getJMSPriority());
                    dmsg.setHeader("JMSRedelivered", message.getJMSRedelivered());
                    dmsg.setHeader("JMSDeliveryMode", message.getJMSDeliveryMode());
                    dmsg.setHeader("DSDstClientId", this.subscriptionId);
                    JMSClientImpl.this.channel.receive(dmsg);
                }
                catch (IOException e) {
                    if (JMSServiceAdapter.this.transactedSessions) {
                        try {
                            this.jmsConsumerSession.rollback();
                        }
                        catch (JMSException f) {
                            log.error("Could not rollback JMS session, messageId: %s", dmsg.getMessageId());
                        }
                    }
                    throw new RuntimeException("IO Error", e);
                }
                catch (JMSException e) {
                    if (JMSServiceAdapter.this.transactedSessions) {
                        try {
                            this.jmsConsumerSession.rollback();
                        }
                        catch (JMSException f) {
                            log.error("Could not rollback JMS session, messageId: %s", dmsg.getMessageId());
                        }
                    }
                    throw new RuntimeException("JMS Error", e);
                }
                catch (MessageReceivingException e) {
                    if (JMSServiceAdapter.this.transactedSessions) {
                        try {
                            this.jmsConsumerSession.rollback();
                        }
                        catch (JMSException f) {
                            log.error("Could not rollback JMS session, messageId: %s", dmsg.getMessageId());
                        }
                    }
                    throw new RuntimeException("Channel delivery Error", e);
                }
                try {
                    if (JMSServiceAdapter.this.acknowledgeMode == 2) {
                        message.acknowledge();
                    }
                    if (JMSServiceAdapter.this.transactedSessions && !this.useGlassFishNoCommitWorkaround) {
                        this.jmsConsumerSession.commit();
                    }
                }
                catch (JMSException e) {
                    if (e.getMessage() != null && e.getMessage().startsWith("MQJMSRA_DS4001")) {
                        this.useGlassFishNoCommitWorkaround = true;
                    }
                    log.error(e, "Could not ack/commit JMS onMessage, messageId: %s", dmsg.getMessageId());
                }
            }

            private String denormalizeJMSMessageID(String messageId) {
                if (messageId != null && messageId.startsWith("ID:")) {
                    messageId = messageId.substring(3);
                }
                return messageId;
            }
        }

        private class ConnectionExceptionListener
        implements ExceptionListener {
            private ConnectionExceptionListener() {
            }

            public void onException(JMSException ex) {
                JMSClientImpl.this.jmsProducer = null;
                for (JMSConsumer consumer : JMSClientImpl.this.consumers.values()) {
                    consumer.reset();
                }
                JMSClientImpl.this.consumers.clear();
                JMSClientImpl.this.jmsConnection = null;
                JMSClientImpl.this.jmsProducerSession = null;
            }
        }
    }
}

