/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.lang.reflect.InvocationTargetException;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.reflect.ClassDescriptor;
import org.granite.messaging.reflect.Property;

public class JMFObjectInputStream
extends ObjectInputStream {
    private final InputContext in;
    private final ClassDescriptor desc;
    private final Object v;

    public JMFObjectInputStream(InputContext in, ClassDescriptor desc, Object v) throws IOException {
        this.in = in;
        this.desc = desc;
        this.v = v;
    }

    @Override
    protected Object readObjectOverride() throws ClassNotFoundException, IOException {
        return this.in.readObject();
    }

    @Override
    public void defaultReadObject() throws IOException, ClassNotFoundException {
        for (Property property : this.desc.getSerializableProperties()) {
            try {
                this.in.readAndSetProperty(this.v, property);
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
            catch (InvocationTargetException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public Object readUnshared() throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        return this.in.read(buf, off, len);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.in.readChar();
    }

    @Override
    public short readShort() throws IOException {
        return this.in.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    @Override
    public void readFully(byte[] buf) throws IOException {
        this.in.readFully(buf);
    }

    @Override
    public void readFully(byte[] buf, int off, int len) throws IOException {
        this.in.readFully(buf, off, len);
    }

    @Override
    public int skipBytes(int len) throws IOException {
        return this.in.skipBytes(len);
    }

    @Override
    public String readLine() throws IOException {
        return this.in.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.in.readUTF();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

