/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.lang.reflect.Array;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;

public abstract class AbstractArrayCodec
extends AbstractStandardCodec<Object> {
    protected int getArrayDimensions(Object v) {
        int dimensions = 0;
        Class<?> componentType = v.getClass().getComponentType();
        while (componentType.isArray()) {
            ++dimensions;
            componentType = componentType.getComponentType();
        }
        return dimensions;
    }

    protected Class<?> getComponentType(Object v) {
        Class<?> componentType = v.getClass().getComponentType();
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
        }
        return componentType;
    }

    protected Object newArray(Class<?> type, int length, int dimensions) {
        int[] ld = new int[dimensions + 1];
        ld[0] = length;
        return Array.newInstance(type, ld);
    }

    protected static class ArrayStructure {
        public final Class<?> componentType;
        public final int dimensions;

        public ArrayStructure(Object array) {
            this(array.getClass());
        }

        public ArrayStructure(Class<?> arrayClass) {
            Class<?> componentType = arrayClass.getComponentType();
            int dimensions = 0;
            while (componentType.isArray()) {
                componentType = componentType.getComponentType();
                ++dimensions;
            }
            this.componentType = componentType;
            this.dimensions = dimensions;
        }

        public String toString() {
            return this.componentType.getName() + "^" + this.dimensions;
        }
    }
}

