/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import org.granite.util.AbstractIndexedCache;

public final class ObjectIndexedCache
extends AbstractIndexedCache<Object> {
    public ObjectIndexedCache() {
        this.init(64);
    }

    public ObjectIndexedCache(int capacity) {
        this.init(ObjectIndexedCache.roundUpToPowerOf2(capacity));
    }

    @Override
    public int putIfAbsent(Object key) {
        int hash = System.identityHashCode(key);
        int index = hash & this.entries.length - 1;
        AbstractIndexedCache.Entry head = this.entries[index];
        if (head != null) {
            AbstractIndexedCache.Entry entry = head;
            do {
                if (key != entry.key) continue;
                return entry.index;
            } while ((entry = entry.next) != null);
            if (this.size >= this.threshold) {
                index = hash & this.resize(this.entries.length * 2);
                head = this.entries[index];
            }
        }
        this.entries[index] = new AbstractIndexedCache.Entry(key, hash, this.size, head);
        ++this.size;
        return -1;
    }
}

