/*
 * Decompiled with CFR 0.152.
 */
package org.granite.gravity;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import java.security.Principal;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import org.granite.config.GraniteConfig;
import org.granite.config.flex.ServicesConfig;
import org.granite.gravity.Channel;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityConfig;
import org.granite.gravity.GravityManager;

public class GravityProxy
implements Gravity {
    private ServletContext servletContext;
    private Set<Gravity.Listener> listeners = new CopyOnWriteArraySet<Gravity.Listener>();
    private ServletContextAttributeListener gravityListener = new ServletContextAttributeListener(){

        public void attributeReplaced(ServletContextAttributeEvent event) {
        }

        public void attributeRemoved(ServletContextAttributeEvent event) {
        }

        public void attributeAdded(ServletContextAttributeEvent event) {
            if (event.getName().equals(GravityManager.GRAVITY_KEY)) {
                Gravity gravity = (Gravity)event.getValue();
                for (Gravity.Listener listener : GravityProxy.this.listeners) {
                    gravity.registerListener(listener);
                }
                GravityProxy.this.listeners.clear();
            }
        }
    };

    public GravityProxy() {
    }

    public GravityProxy(ServletContext servletContext) {
        this.servletContext = servletContext;
        try {
            servletContext.addListener((EventListener)this.gravityListener);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected Gravity getGravity() {
        return GravityManager.getGravity(this.servletContext);
    }

    @Override
    public GravityConfig getGravityConfig() {
        return this.getGravity().getGravityConfig();
    }

    @Override
    public ServicesConfig getServicesConfig() {
        return this.getGravity().getServicesConfig();
    }

    @Override
    public GraniteConfig getGraniteConfig() {
        return this.getGravity().getGraniteConfig();
    }

    @Override
    public boolean isStarted() {
        return this.getGravity().isStarted();
    }

    @Override
    public void start() throws Exception {
        this.getGravity().start();
    }

    @Override
    public void reconfigure(GravityConfig gravityConfig, GraniteConfig graniteConfig) {
        this.getGravity().reconfigure(gravityConfig, graniteConfig);
    }

    @Override
    public void stop() throws Exception {
        this.getGravity().stop();
    }

    @Override
    public void stop(boolean now) throws Exception {
        this.getGravity().stop(now);
    }

    @Override
    public List<Channel> getConnectedChannels() {
        return this.getGravity().getConnectedChannels();
    }

    @Override
    public Set<Principal> getConnectedUsers() {
        return this.getGravity().getConnectedUsers();
    }

    @Override
    public List<Channel> getConnectedChannelsByDestination(String destination) {
        return this.getGravity().getConnectedChannelsByDestination(destination);
    }

    @Override
    public Set<Principal> getConnectedUsersByDestination(String destination) {
        return this.getGravity().getConnectedUsersByDestination(destination);
    }

    @Override
    public List<Channel> findConnectedChannelsByUser(String name) {
        return this.getGravity().findConnectedChannelsByUser(name);
    }

    @Override
    public Channel findChannelByClientId(String clientId) {
        return this.getGravity().findChannelByClientId(clientId);
    }

    @Override
    public Channel findCurrentChannel(String destination) {
        return this.getGravity().findCurrentChannel(destination);
    }

    @Override
    public Message handleMessage(Message message) {
        return this.getGravity().handleMessage(message);
    }

    @Override
    public Message handleMessage(Message message, boolean skipInterceptor) {
        return this.getGravity().handleMessage(message, skipInterceptor);
    }

    @Override
    public Message publishMessage(AsyncMessage message) {
        return this.publishMessage(null, message);
    }

    @Override
    public Message publishMessage(Channel fromChannel, AsyncMessage message) {
        Gravity gravity = this.getGravity();
        if (gravity == null) {
            return new ErrorMessage((Message)message, new IllegalStateException("Gravity not initialized"));
        }
        return this.getGravity().publishMessage(fromChannel, message);
    }

    @Override
    public Message sendRequest(Channel fromChannel, AsyncMessage message) {
        Gravity gravity = this.getGravity();
        if (gravity == null) {
            return new ErrorMessage((Message)message, new IllegalStateException("Gravity not initialized"));
        }
        return this.getGravity().sendRequest(fromChannel, message);
    }

    @Override
    public void registerListener(Gravity.Listener listener) {
        if (this.getGravity() == null) {
            this.listeners.add(listener);
            return;
        }
        this.getGravity().registerListener(listener);
    }

    @Override
    public void unregisterListener(Gravity.Listener listener) {
        if (this.getGravity() == null) {
            this.listeners.remove(listener);
            return;
        }
        this.getGravity().unregisterListener(listener);
    }
}

