/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.granite.messaging.amf.io.util.ActionScriptClassDescriptor;
import org.granite.messaging.amf.io.util.FieldProperty;
import org.granite.messaging.amf.io.util.MapProperty;
import org.granite.messaging.amf.io.util.MethodProperty;
import org.granite.messaging.amf.io.util.UIDProperty;
import org.granite.util.Introspector;
import org.granite.util.PropertyDescriptor;
import org.granite.util.TypeUtil;

public class DefaultActionScriptClassDescriptor
extends ActionScriptClassDescriptor {
    private final Class<?> clazz;

    public DefaultActionScriptClassDescriptor(String type, byte encoding) {
        super(type, encoding);
        this.clazz = DefaultActionScriptClassDescriptor.forName(type, this.instantiator);
    }

    private static Class<?> forName(String name, String instantiator) {
        if (name.length() == 0) {
            return HashMap.class;
        }
        String className = instantiator != null ? instantiator : name;
        try {
            return TypeUtil.forName(className);
        }
        catch (Throwable t) {
            throw new RuntimeException("Class not found: " + className);
        }
    }

    @Override
    public void defineProperty(String name) {
        if (this.type.length() == 0 || this.instantiator != null) {
            this.properties.add(new MapProperty(this.converters, name));
        } else {
            try {
                PropertyDescriptor[] props;
                for (PropertyDescriptor prop : props = Introspector.getPropertyDescriptors(this.clazz)) {
                    if (!name.equals(prop.getName()) || prop.getWriteMethod() == null || prop.getReadMethod() == null) continue;
                    this.properties.add(new MethodProperty(this.converters, name, prop.getWriteMethod(), prop.getReadMethod()));
                    return;
                }
                Field field = this.clazz.getField(name);
                if (!Modifier.isStatic(field.getModifiers()) && !Modifier.isTransient(field.getModifiers())) {
                    this.properties.add(new FieldProperty(this.converters, field));
                }
            }
            catch (NoSuchFieldException e) {
                if ("uid".equals(name)) {
                    this.properties.add(new UIDProperty(this.converters));
                }
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Object newJavaInstance() {
        if (this.clazz == HashMap.class) {
            return new HashMap();
        }
        try {
            return this.clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create instance of: " + this.clazz.getName(), e);
        }
    }
}

