/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.util;

import java.io.Externalizable;
import java.util.List;
import java.util.Map;
import org.granite.config.ConvertersConfig;
import org.granite.config.ExternalizersConfig;
import org.granite.config.api.AliasRegistryConfig;
import org.granite.context.GraniteContext;
import org.granite.messaging.amf.io.convert.Converters;
import org.granite.messaging.amf.io.util.Property;
import org.granite.messaging.amf.io.util.externalizer.Externalizer;

public abstract class JavaClassDescriptor {
    protected final Class<?> type;
    protected final String name;
    protected final Externalizer externalizer;
    protected final Converters converters;
    protected final byte encoding;
    protected final Property[] properties;

    protected JavaClassDescriptor(Class<?> type) {
        Object config = GraniteContext.getCurrentInstance().getGraniteConfig();
        this.type = type;
        this.name = JavaClassDescriptor.getClassName(type);
        this.externalizer = ((ExternalizersConfig)config).getExternalizer(type.getName());
        this.converters = ((ConvertersConfig)config).getConverters();
        this.encoding = this.findEncoding(type);
        List<Property> properties = this.introspectProperties();
        this.properties = properties != null ? properties.toArray(new Property[0]) : new Property[]{};
    }

    private byte findEncoding(Class<?> type) {
        if (this.externalizer != null || Externalizable.class.isAssignableFrom(type)) {
            return 1;
        }
        if (Map.class.isAssignableFrom(type)) {
            return 2;
        }
        return 0;
    }

    protected abstract List<Property> introspectProperties();

    public static String getClassName(Class<?> clazz) {
        Externalizer externalizer;
        if (Map.class.isAssignableFrom(clazz) && !Externalizable.class.isAssignableFrom(clazz) && (externalizer = ((ExternalizersConfig)GraniteContext.getCurrentInstance().getGraniteConfig()).getExternalizer(clazz.getName())) == null) {
            return "";
        }
        return ((AliasRegistryConfig)GraniteContext.getCurrentInstance().getGraniteConfig()).getAliasRegistry().getAliasForType(clazz.getName());
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Externalizer getExternalizer() {
        return this.externalizer;
    }

    public byte getEncoding() {
        return this.encoding;
    }

    public boolean isExternalizable() {
        return this.encoding == 1;
    }

    public boolean isDynamic() {
        return this.encoding == 2;
    }

    public int getPropertiesCount() {
        return this.properties.length;
    }

    public Property getProperty(int index) {
        return this.properties[index];
    }

    public String getPropertyName(int index) {
        return this.properties[index].getName();
    }

    public Object getPropertyValue(int index, Object instance) {
        return this.properties[index].getValue(instance);
    }
}

