/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.jmf.codec.std.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.granite.messaging.jmf.DumpContext;
import org.granite.messaging.jmf.InputContext;
import org.granite.messaging.jmf.OutputContext;
import org.granite.messaging.jmf.codec.std.FloatCodec;
import org.granite.messaging.jmf.codec.std.impl.AbstractStandardCodec;
import org.granite.messaging.jmf.codec.std.impl.util.FloatUtil;

public class FloatCodecImpl
extends AbstractStandardCodec<Float>
implements FloatCodec {
    @Override
    public int getObjectType() {
        return 126;
    }

    @Override
    public Class<?> getObjectClass() {
        return Float.class;
    }

    @Override
    public int getPrimitiveType() {
        return 125;
    }

    @Override
    public Class<?> getPrimitiveClass() {
        return Float.TYPE;
    }

    @Override
    public void encode(OutputContext ctx, Float v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        os.write(126);
        FloatUtil.encodeFloat(ctx, v.floatValue());
    }

    @Override
    public Float decode(InputContext ctx, int parameterizedJmfType) throws IOException {
        return Float.valueOf(FloatUtil.decodeFloat(ctx));
    }

    @Override
    public void encodePrimitive(OutputContext ctx, float v) throws IOException {
        OutputStream os = ctx.getOutputStream();
        os.write(125);
        FloatUtil.encodeFloat(ctx, v);
    }

    @Override
    public float decodePrimitive(InputContext ctx) throws IOException {
        ctx.safeRead();
        return FloatUtil.decodeFloat(ctx);
    }

    @Override
    public void dump(DumpContext ctx, int parameterizedJmfType) throws IOException {
        int jmfType = ctx.getSharedContext().getCodecRegistry().extractJmfType(parameterizedJmfType);
        switch (jmfType) {
            case 125: {
                ctx.indentPrintLn("float: " + FloatUtil.decodeFloat(ctx));
                break;
            }
            case 126: {
                ctx.indentPrintLn(Float.class.getName() + ": " + Float.valueOf(FloatUtil.decodeFloat(ctx)));
                break;
            }
            default: {
                throw this.newBadTypeJMFEncodingException(jmfType, parameterizedJmfType);
            }
        }
    }
}

