/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.reflect;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.granite.messaging.annotations.Exclude;
import org.granite.messaging.annotations.Include;
import org.granite.messaging.annotations.Serialized;
import org.granite.messaging.reflect.ConstructorInstantiator;
import org.granite.messaging.reflect.Instantiator;
import org.granite.messaging.reflect.Property;
import org.granite.messaging.reflect.Reflection;
import org.granite.messaging.reflect.ReflectionException;

public class ClassDescriptor {
    private static final Class<?>[] WRITE_OBJECT_PARAMS = new Class[]{ObjectOutputStream.class};
    private static final Class<?>[] READ_OBJECT_PARAMS = new Class[]{ObjectInputStream.class};
    private final Class<?> cls;
    private final Instantiator instantiator;
    private final List<Property> properties;
    private final Method writeObjectMethod;
    private final Method readObjectMethod;
    private final Method writeReplaceMethod;
    private final Method readResolveMethod;
    private final ClassDescriptor parent;
    private volatile SoftReference<List<Property>> inheritedProperties = new SoftReference<Object>(null);

    public ClassDescriptor(Reflection reflection, Class<?> cls) {
        this.cls = cls;
        this.instantiator = ClassDescriptor.getInstantiator(reflection, cls);
        if (!Externalizable.class.isAssignableFrom(cls)) {
            this.writeObjectMethod = ClassDescriptor.getPrivateMethod(cls, "writeObject", WRITE_OBJECT_PARAMS, Void.TYPE);
            this.readObjectMethod = ClassDescriptor.getPrivateMethod(cls, "readObject", READ_OBJECT_PARAMS, Void.TYPE);
        } else {
            this.writeObjectMethod = null;
            this.readObjectMethod = null;
        }
        this.writeReplaceMethod = ClassDescriptor.getInheritedMethod(cls, "writeReplace", null, Object.class);
        this.readResolveMethod = ClassDescriptor.getInheritedMethod(cls, "readResolve", null, Object.class);
        this.properties = ClassDescriptor.getSerializableProperties(reflection, cls);
        this.parent = reflection.getDescriptor(cls.getSuperclass());
    }

    private static Instantiator getInstantiator(Reflection reflection, Class<?> cls) {
        try {
            return new ConstructorInstantiator(cls.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            try {
                return reflection.instanceFactory.newInstantiator(cls);
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException(e2);
            }
            catch (InvocationTargetException e3) {
                throw new RuntimeException(e3);
            }
        }
    }

    public Class<?> getCls() {
        return this.cls;
    }

    public Object newInstance() throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return this.instantiator.newInstance();
    }

    public List<Property> getSerializableProperties() {
        return this.properties;
    }

    public List<Property> getInheritedSerializableProperties() {
        List<Property> inheritedSerializableProperties = this.inheritedProperties.get();
        if (inheritedSerializableProperties == null) {
            if (this.parent == null) {
                inheritedSerializableProperties = this.properties;
            } else {
                List<Property> parentProperties = this.parent.getInheritedSerializableProperties();
                if (!parentProperties.isEmpty()) {
                    if (!this.properties.isEmpty()) {
                        inheritedSerializableProperties = new ArrayList<Property>(parentProperties.size() + this.properties.size());
                        inheritedSerializableProperties.addAll(parentProperties);
                        inheritedSerializableProperties.addAll(this.properties);
                        inheritedSerializableProperties = Collections.unmodifiableList(inheritedSerializableProperties);
                    } else {
                        inheritedSerializableProperties = parentProperties;
                    }
                } else {
                    inheritedSerializableProperties = this.properties;
                }
            }
            this.inheritedProperties = new SoftReference<List<Property>>(inheritedSerializableProperties);
        }
        return inheritedSerializableProperties;
    }

    public boolean hasWriteObjectMethod() {
        return this.writeObjectMethod != null;
    }

    public void invokeWriteObjectMethod(ObjectOutputStream oos, Object v) throws IOException {
        if (this.writeObjectMethod == null) {
            throw new UnsupportedOperationException("No writeObject(...) method in " + this.cls);
        }
        try {
            this.writeObjectMethod.invoke(v, oos);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t);
        }
        catch (IllegalAccessException e) {
            throw new InternalError();
        }
    }

    public boolean hasReadObjectMethod() {
        return this.readObjectMethod != null;
    }

    public void invokeReadObjectMethod(ObjectInputStream ois, Object v) throws ClassNotFoundException, IOException {
        if (this.readObjectMethod == null) {
            throw new UnsupportedOperationException("No readObject(...) method in " + this.cls);
        }
        try {
            this.readObjectMethod.invoke(v, ois);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t);
        }
        catch (IllegalAccessException e) {
            throw new InternalError();
        }
    }

    public boolean hasWriteReplaceMethod() {
        return this.writeReplaceMethod != null;
    }

    public Object invokeWriteReplaceMethod(Object v) throws IOException {
        if (this.writeReplaceMethod == null) {
            throw new UnsupportedOperationException("No writeReplace() method in " + this.cls);
        }
        try {
            return this.writeReplaceMethod.invoke(v, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t);
        }
        catch (IllegalAccessException e) {
            throw new InternalError();
        }
    }

    public boolean hasReadResolveMethod() {
        return this.readResolveMethod != null;
    }

    public Object invokeReadResolveMethod(Object v) throws IOException {
        if (this.readResolveMethod == null) {
            throw new UnsupportedOperationException("No readResolve() method in " + this.cls);
        }
        try {
            return this.readResolveMethod.invoke(v, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t);
        }
        catch (IllegalAccessException e) {
            throw new InternalError();
        }
    }

    public ClassDescriptor getParent() {
        return this.parent;
    }

    protected static Method getInheritedMethod(Class<?> cls, String name, Class<?>[] params, Class<?> ret) {
        try {
            Method method = cls.getDeclaredMethod(name, params);
            method.setAccessible(true);
            return method.getReturnType() == ret && (0x408 & method.getModifiers()) == 0 ? method : null;
        }
        catch (NoSuchMethodException e) {
            Class<?> root = cls;
            while ((cls = cls.getSuperclass()) != null) {
                try {
                    Method method = cls.getDeclaredMethod(name, params);
                    method.setAccessible(true);
                    if (method.getReturnType() != ret) {
                        return null;
                    }
                    int modifiers = method.getModifiers();
                    if ((0x40A & modifiers) != 0) {
                        return null;
                    }
                    if ((5 & modifiers) != 0) {
                        return method;
                    }
                    return root.getPackage() == cls.getPackage() ? method : null;
                }
                catch (NoSuchMethodException e2) {
                }
            }
            return null;
        }
    }

    protected static Method getPrivateMethod(Class<?> cls, String name, Class<?>[] params, Class<?> ret) {
        try {
            Method method = cls.getDeclaredMethod(name, params);
            method.setAccessible(true);
            if (method.getReturnType() == ret && (method.getModifiers() & 0xA) == 2) {
                return method;
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return null;
    }

    protected static List<Property> getSerializableProperties(Reflection reflection, Class<?> cls) {
        Method[] declaredMethods;
        Field[] declaredFields = cls.getDeclaredFields();
        ArrayList<Property> serializableProperties = new ArrayList<Property>(declaredFields.length);
        for (Field field : declaredFields) {
            if ((field.getModifiers() & 0x88) != 0 || field.isAnnotationPresent(Exclude.class)) continue;
            field.setAccessible(true);
            serializableProperties.add(reflection.newFieldProperty(field));
        }
        for (Method method : declaredMethods = cls.getDeclaredMethods()) {
            if ((method.getModifiers() & 0xE) != 0 || method.getReturnType() == Void.TYPE || !method.isAnnotationPresent(Include.class) || method.getParameterTypes().length != 0) continue;
            String name = method.getName();
            if (name.startsWith("get")) {
                if (name.length() <= 3) continue;
                name = name.substring(3, 4).toLowerCase() + name.substring(4);
            } else {
                if (!name.startsWith("is") || method.getReturnType() != Boolean.class && method.getReturnType() != Boolean.TYPE || name.length() <= 2) continue;
                name = name.substring(2, 3).toLowerCase() + name.substring(3);
            }
            serializableProperties.add(reflection.newMethodProperty(method, null, name));
        }
        Serialized serialized = cls.getAnnotation(Serialized.class);
        if (serialized != null && serialized.propertiesOrder().length > 0) {
            String[] value = serialized.propertiesOrder();
            if (value.length != serializableProperties.size()) {
                throw new ReflectionException("Illegal @Serialized(propertiesOrder) value: " + serialized + " on: " + cls.getName() + " (bad length)");
            }
            for (int i = 0; i < value.length; ++i) {
                String propertyName = value[i];
                boolean found = false;
                for (int j = i; j < value.length; ++j) {
                    Property property = (Property)serializableProperties.get(j);
                    if (!property.getName().equals(propertyName)) continue;
                    found = true;
                    if (i == j) break;
                    serializableProperties.set(j, (Property)serializableProperties.get(i));
                    serializableProperties.set(i, property);
                    break;
                }
                if (found) continue;
                throw new ReflectionException("Illegal @Serialized(propertiesOrder) value: " + serialized + " on: " + cls.getName() + " (\"" + propertyName + "\" isn't a property name)");
            }
        } else {
            Collections.sort(serializableProperties, reflection.getLexicalPropertyComparator());
        }
        return Collections.unmodifiableList(serializableProperties);
    }
}

