/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service.security;

import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Date;
import javax.servlet.http.HttpSession;
import org.granite.clustering.DistributedData;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.logging.Logger;
import org.granite.messaging.service.security.AbstractSecurityContext;
import org.granite.messaging.service.security.SecurityService;
import org.granite.messaging.service.security.SecurityServiceException;
import org.granite.messaging.webapp.ServletGraniteContext;
import org.granite.util.Base64;

public abstract class AbstractSecurityService
implements SecurityService {
    private static final Logger log = Logger.getLogger(AbstractSecurityService.class);
    public static final String AUTH_TYPE = "granite-security";

    @Override
    public void prelogin(HttpSession session, Object request, String servletName) {
    }

    @Override
    public Principal login(Object credentials) throws SecurityServiceException {
        return this.login(credentials, null);
    }

    protected void startAuthorization(AbstractSecurityContext context) throws SecurityServiceException {
        Object credentials = context.getMessage().getHeader("DSRemoteCredentials");
        if (credentials != null && !"".equals(credentials)) {
            this.login(credentials, (String)context.getMessage().getHeader("DSRemoteCredentialsCharset"));
        }
        if (GraniteContext.getCurrentInstance() instanceof ServletGraniteContext) {
            HttpSession session = ((ServletGraniteContext)GraniteContext.getCurrentInstance()).getSession(false);
            if (session == null) {
                return;
            }
            long serverTime = new Date().getTime();
            try {
                Long lastAccessedTime = (Long)session.getAttribute("org.granite.session.lastAccessedTime");
                if (lastAccessedTime != null && lastAccessedTime + (long)session.getMaxInactiveInterval() * 1000L + 1000L < serverTime) {
                    log.info("No user-initiated action since last access, force session invalidation", new Object[0]);
                    session.invalidate();
                }
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
    }

    protected Object endAuthorization(AbstractSecurityContext context) throws Exception {
        return context.invoke();
    }

    @Override
    public boolean acceptsContext() {
        return GraniteContext.getCurrentInstance() instanceof ServletGraniteContext;
    }

    protected String[] decodeBase64Credentials(Object credentials, String charset) {
        String decoded;
        if (!(credentials instanceof String)) {
            throw new IllegalArgumentException("Credentials should be a non null String: " + (credentials != null ? credentials.getClass().getName() : null));
        }
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        byte[] bytes = Base64.decode((String)credentials);
        try {
            decoded = new String(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw SecurityServiceException.newInvalidCredentialsException("ISO-8859-1 encoding not supported ???");
        }
        int colon = decoded.indexOf(58);
        if (colon == -1) {
            throw SecurityServiceException.newInvalidCredentialsException("No colon");
        }
        return new String[]{decoded.substring(0, colon), decoded.substring(colon + 1)};
    }

    @Override
    public void handleSecurityException(SecurityServiceException e) {
    }

    protected void endLogin(Object credentials, String charset) {
        try {
            DistributedData gdd = ((GraniteConfig)GraniteContext.getCurrentInstance().getGraniteConfig()).getDistributedDataFactory().getInstance();
            if (gdd != null) {
                gdd.setCredentials(credentials);
                gdd.setCredentialsCharset(charset);
            }
        }
        catch (Exception e) {
            log.error(e, "Could not save credentials in distributed data", new Object[0]);
        }
    }

    protected boolean tryRelogin() {
        try {
            Object credentials;
            DistributedData gdd = ((GraniteConfig)GraniteContext.getCurrentInstance().getGraniteConfig()).getDistributedDataFactory().getInstance();
            if (gdd != null && (credentials = gdd.getCredentials()) != null) {
                String charset = gdd.getCredentialsCharset();
                try {
                    this.login(credentials, charset);
                    return true;
                }
                catch (SecurityServiceException e) {}
            }
        }
        catch (Exception e) {
            log.error(e, "Could not relogin with credentials found in distributed data", new Object[0]);
        }
        return false;
    }

    protected void endLogout() {
        try {
            DistributedData gdd = ((GraniteConfig)GraniteContext.getCurrentInstance().getGraniteConfig()).getDistributedDataFactory().getInstance();
            if (gdd != null) {
                gdd.removeCredentials();
                gdd.removeCredentialsCharset();
            }
        }
        catch (Exception e) {
            log.error(e, "Could not remove credentials from distributed data", new Object[0]);
        }
    }
}

