/*
 * Decompiled with CFR 0.152.
 */
package org.granite.tide.data;

import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import java.util.Map;
import org.granite.clustering.DistributedData;
import org.granite.clustering.DistributedDataFactory;
import org.granite.config.GraniteConfig;
import org.granite.context.GraniteContext;
import org.granite.gravity.Channel;
import org.granite.gravity.Gravity;
import org.granite.gravity.GravityManager;
import org.granite.logging.Logger;
import org.granite.messaging.webapp.ServletGraniteContext;
import org.granite.tide.data.AbstractDataDispatcher;
import org.granite.tide.data.DataTopicParams;

public class DefaultDataDispatcher
extends AbstractDataDispatcher {
    private static final Logger log = Logger.getLogger(DefaultDataDispatcher.class);
    private Gravity gravity = null;

    public DefaultDataDispatcher(Gravity gravity, String topicName, Class<? extends DataTopicParams> dataTopicParamsClass) {
        super(topicName, dataTopicParamsClass);
        GraniteContext graniteContext = GraniteContext.getCurrentInstance();
        if (!(gravity != null || graniteContext != null && graniteContext instanceof ServletGraniteContext)) {
            return;
        }
        DistributedDataFactory distributedDataFactory = gravity != null ? gravity.getGraniteConfig().getDistributedDataFactory() : ((GraniteConfig)graniteContext.getGraniteConfig()).getDistributedDataFactory();
        DistributedData gdd = distributedDataFactory.getInstance();
        if (gdd != null) {
            this.gravity = GravityManager.getGravity(((ServletGraniteContext)graniteContext).getServletContext());
            if (this.gravity == null) {
                log.debug("Gravity not found or HTTP session not found, data dispatch disabled", new Object[0]);
                return;
            }
            this.clientId = gdd.getDestinationClientId(topicName);
            this.subscriptionId = gdd.getDestinationSubscriptionId(topicName);
            this.sessionId = graniteContext.getSessionId();
        } else {
            if (gravity == null) {
                gravity = GravityManager.getGravity(((ServletGraniteContext)graniteContext).getServletContext());
            }
            if (gravity == null) {
                log.debug("Gravity not defined, data dispatch disabled", new Object[0]);
                return;
            }
            this.gravity = gravity;
            this.sessionId = "__GDS_SERVER_DISPATCHER__";
        }
        this.enabled = true;
    }

    @Override
    protected void changeDataSelector(String dataSelector) {
        DistributedDataFactory distributedDataFactory = ((GraniteConfig)GraniteContext.getCurrentInstance().getGraniteConfig()).getDistributedDataFactory();
        DistributedData gdd = distributedDataFactory.getInstance();
        if (gdd != null) {
            String clientId = gdd.getDestinationClientId(this.topicName);
            String subscriptionId = gdd.getDestinationSubscriptionId(this.topicName);
            if (clientId != null) {
                CommandMessage message = new CommandMessage();
                message.setClientId(clientId);
                message.setHeader("DSDstClientId", subscriptionId);
                message.setHeader("DSSubtopic", "tideDataTopic");
                message.setDestination(this.topicName);
                message.setOperation(0);
                message.setHeader("DSSelector", dataSelector);
                this.gravity.handleMessage(message, true);
                log.debug("Topic %s data selector changed: %s", this.topicName, dataSelector);
            }
        }
    }

    @Override
    public void publishUpdate(Map<String, Object> params, Object body) {
        AsyncMessage message = new AsyncMessage();
        message.setDestination(this.topicName);
        for (Map.Entry<String, Object> hh : params.entrySet()) {
            message.setHeader(hh.getKey(), hh.getValue());
        }
        message.setBody(body);
        Message resultMessage = null;
        if (this.clientId != null) {
            Channel channel = this.gravity.findChannelByClientId(this.clientId);
            message.setClientId(this.clientId);
            resultMessage = this.gravity.publishMessage(channel, message);
        } else {
            resultMessage = this.gravity.publishMessage(message);
        }
        if (resultMessage instanceof ErrorMessage) {
            log.error("Could not dispatch data update on topic %s, message %s", this.topicName, resultMessage.toString());
        } else {
            log.debug("Data message dispatched on topic %s", this.topicName);
        }
    }
}

