/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.vm;

import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.vm.AutoBeanFactorySource;
import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.requestfactory.shared.BaseProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxyId;
import com.google.web.bindery.requestfactory.shared.JsonRpcService;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestFactory;
import com.google.web.bindery.requestfactory.shared.ValueProxy;
import com.google.web.bindery.requestfactory.shared.impl.AbstractRequestContext;
import com.google.web.bindery.requestfactory.shared.impl.AbstractRequestFactory;
import com.google.web.bindery.requestfactory.shared.impl.BaseProxyCategory;
import com.google.web.bindery.requestfactory.shared.impl.EntityProxyCategory;
import com.google.web.bindery.requestfactory.shared.impl.ValueProxyCategory;
import com.google.web.bindery.requestfactory.vm.InProcessRequestContext;
import com.google.web.bindery.requestfactory.vm.impl.Deobfuscator;
import com.google.web.bindery.requestfactory.vm.impl.OperationKey;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

class InProcessRequestFactory
extends AbstractRequestFactory {
    private final Class<? extends RequestFactory> requestFactoryInterface;
    private final Deobfuscator deobfuscator;

    public InProcessRequestFactory(Class<? extends RequestFactory> requestFactoryInterface) {
        this.requestFactoryInterface = requestFactoryInterface;
        this.deobfuscator = Deobfuscator.Builder.load(requestFactoryInterface, Thread.currentThread().getContextClassLoader()).build();
    }

    public Deobfuscator getDeobfuscator() {
        return this.deobfuscator;
    }

    @Override
    public String getFactoryTypeToken() {
        return this.requestFactoryInterface.getName();
    }

    @Override
    public void initialize(EventBus eventBus) {
        throw new UnsupportedOperationException("An explicit RequestTransport must be provided");
    }

    @Override
    public boolean isEntityType(Class<?> clazz) {
        return EntityProxy.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean isValueType(Class<?> clazz) {
        return ValueProxy.class.isAssignableFrom(clazz);
    }

    @Override
    protected AutoBeanFactory getAutoBeanFactory() {
        return AutoBeanFactorySource.create(Factory.class);
    }

    @Override
    protected <P extends BaseProxy> Class<P> getTypeFromToken(String typeToken) {
        String deobfuscated = this.deobfuscator.getTypeFromToken(typeToken);
        if (deobfuscated == null) {
            throw new RuntimeException("Did not have deobfuscation data for " + typeToken);
        }
        try {
            Class<BaseProxy> found = Class.forName(deobfuscated, false, Thread.currentThread().getContextClassLoader()).asSubclass(BaseProxy.class);
            return found;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    protected String getTypeToken(Class<? extends BaseProxy> clazz) {
        return this.isEntityType(clazz) || this.isValueType(clazz) ? OperationKey.hash(clazz.getName()) : null;
    }

    @AutoBeanFactory.Category(value={EntityProxyCategory.class, ValueProxyCategory.class, BaseProxyCategory.class})
    @AutoBeanFactory.NoWrap(value={EntityProxyId.class})
    static interface Factory
    extends AutoBeanFactory {
    }

    class RequestFactoryHandler
    implements InvocationHandler {
        RequestFactoryHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (Object.class.equals(method.getDeclaringClass()) || RequestFactory.class.equals(method.getDeclaringClass())) {
                try {
                    return method.invoke((Object)InProcessRequestFactory.this, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            Class<RequestContext> context = method.getReturnType().asSubclass(RequestContext.class);
            AbstractRequestContext.Dialect dialect = method.getReturnType().isAnnotationPresent(JsonRpcService.class) ? AbstractRequestContext.Dialect.JSON_RPC : AbstractRequestContext.Dialect.STANDARD;
            InProcessRequestContext.RequestContextHandler handler = new InProcessRequestContext.RequestContextHandler(new InProcessRequestContext(InProcessRequestFactory.this, dialect, context));
            return context.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{context}, (InvocationHandler)handler));
        }
    }
}

