/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import org.HdrHistogram.AbstractHistogram;

public class SynchronizedHistogram
extends AbstractHistogram {
    long totalCount;
    final long[] counts;

    @Override
    long getCountAtIndex(int index) {
        return this.counts[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void incrementCountAtIndex(int index) {
        SynchronizedHistogram synchronizedHistogram = this;
        synchronized (synchronizedHistogram) {
            int n = index;
            this.counts[n] = this.counts[n] + 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void addToCountAtIndex(int index, long value) {
        SynchronizedHistogram synchronizedHistogram = this;
        synchronized (synchronizedHistogram) {
            int n = index;
            this.counts[n] = this.counts[n] + value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void clearCounts() {
        SynchronizedHistogram synchronizedHistogram = this;
        synchronized (synchronizedHistogram) {
            Arrays.fill(this.counts, 0L);
            this.totalCount = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void add(AbstractHistogram other) {
        if (this.identityCount < other.identityCount) {
            SynchronizedHistogram synchronizedHistogram = this;
            synchronized (synchronizedHistogram) {
                AbstractHistogram abstractHistogram = other;
                synchronized (abstractHistogram) {
                    super.add(other);
                }
            }
        }
        AbstractHistogram abstractHistogram = other;
        synchronized (abstractHistogram) {
            SynchronizedHistogram synchronizedHistogram = this;
            synchronized (synchronizedHistogram) {
                super.add(other);
            }
        }
    }

    @Override
    public SynchronizedHistogram copy() {
        SynchronizedHistogram copy = new SynchronizedHistogram(this.lowestTrackableValue, this.highestTrackableValue, this.numberOfSignificantValueDigits);
        copy.add(this);
        return copy;
    }

    @Override
    public SynchronizedHistogram copyCorrectedForCoordinatedOmission(long expectedIntervalBetweenValueSamples) {
        SynchronizedHistogram toHistogram = new SynchronizedHistogram(this.lowestTrackableValue, this.highestTrackableValue, this.numberOfSignificantValueDigits);
        toHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
        return toHistogram;
    }

    @Override
    long getTotalCount() {
        return this.totalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setTotalCount(long totalCount) {
        SynchronizedHistogram synchronizedHistogram = this;
        synchronized (synchronizedHistogram) {
            this.totalCount = totalCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void incrementTotalCount() {
        SynchronizedHistogram synchronizedHistogram = this;
        synchronized (synchronizedHistogram) {
            ++this.totalCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void addToTotalCount(long value) {
        SynchronizedHistogram synchronizedHistogram = this;
        synchronized (synchronizedHistogram) {
            this.totalCount += value;
        }
    }

    @Override
    public int getEstimatedFootprintInBytes() {
        return 512 + 8 * this.counts.length;
    }

    public SynchronizedHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(1L, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public SynchronizedHistogram(long lowestTrackableValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        super(lowestTrackableValue, highestTrackableValue, numberOfSignificantValueDigits);
        this.counts = new long[this.countsArrayLength];
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        o.defaultReadObject();
    }
}

