/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.HdrHistogram.AbstractHistogram;

public class AtomicHistogram
extends AbstractHistogram {
    static final AtomicLongFieldUpdater<AtomicHistogram> totalCountUpdater = AtomicLongFieldUpdater.newUpdater(AtomicHistogram.class, "totalCount");
    volatile long totalCount;
    final AtomicLongArray counts;

    @Override
    long getCountAtIndex(int index) {
        return this.counts.get(index);
    }

    @Override
    void incrementCountAtIndex(int index) {
        this.counts.incrementAndGet(index);
    }

    @Override
    void addToCountAtIndex(int index, long value) {
        this.counts.addAndGet(index, value);
    }

    @Override
    void clearCounts() {
        for (int i = 0; i < this.counts.length(); ++i) {
            this.counts.lazySet(i, 0L);
        }
        totalCountUpdater.set(this, 0L);
    }

    @Override
    public AtomicHistogram copy() {
        AtomicHistogram copy = new AtomicHistogram(this.lowestTrackableValue, this.highestTrackableValue, this.numberOfSignificantValueDigits);
        copy.add(this);
        return copy;
    }

    @Override
    public AtomicHistogram copyCorrectedForCoordinatedOmission(long expectedIntervalBetweenValueSamples) {
        AtomicHistogram toHistogram = new AtomicHistogram(this.lowestTrackableValue, this.highestTrackableValue, this.numberOfSignificantValueDigits);
        toHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
        return toHistogram;
    }

    @Override
    long getTotalCount() {
        return totalCountUpdater.get(this);
    }

    @Override
    void setTotalCount(long totalCount) {
        totalCountUpdater.set(this, totalCount);
    }

    @Override
    void incrementTotalCount() {
        totalCountUpdater.incrementAndGet(this);
    }

    @Override
    void addToTotalCount(long value) {
        totalCountUpdater.addAndGet(this, value);
    }

    @Override
    public int getEstimatedFootprintInBytes() {
        return 512 + 8 * this.counts.length();
    }

    public AtomicHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(1L, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public AtomicHistogram(long lowestTrackableValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        super(lowestTrackableValue, highestTrackableValue, numberOfSignificantValueDigits);
        this.counts = new AtomicLongArray(this.countsArrayLength);
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        o.defaultReadObject();
    }
}

