/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.HdrHistogram.AbstractHistogramBase;
import org.HdrHistogram.HistogramData;
import org.HdrHistogram.HistogramIterationValue;

public abstract class AbstractHistogram
extends AbstractHistogramBase
implements Serializable {
    int subBucketHalfCountMagnitude;
    int unitMagnitude;
    int subBucketHalfCount;
    long subBucketMask;
    private static final long serialVersionUID = 42L;
    private static final int encodingCookieBase = 478450440;
    private static final int compressedEncodingCookieBase = 478450441;
    private ByteBuffer intermediateUncompressedByteBuffer = null;
    private static final Class[] constructorArgsTypes = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE};

    abstract long getCountAtIndex(int var1);

    abstract void incrementCountAtIndex(int var1);

    abstract void addToCountAtIndex(int var1, long var2);

    abstract long getTotalCount();

    abstract void setTotalCount(long var1);

    abstract void incrementTotalCount();

    abstract void addToTotalCount(long var1);

    abstract void clearCounts();

    abstract int _getEstimatedFootprintInBytes();

    public abstract AbstractHistogram copy();

    public abstract AbstractHistogram copyCorrectedForCoordinatedOmission(long var1);

    public int getEstimatedFootprintInBytes() {
        return this._getEstimatedFootprintInBytes();
    }

    public void copyInto(AbstractHistogram targetHistogram) {
        targetHistogram.reset();
        targetHistogram.add(this);
    }

    public void copyIntoCorrectedForCoordinatedOmission(AbstractHistogram targetHistogram, long expectedIntervalBetweenValueSamples) {
        targetHistogram.reset();
        targetHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
    }

    public AbstractHistogram(long lowestTrackableValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        if (lowestTrackableValue < 1L) {
            throw new IllegalArgumentException("lowestTrackableValue must be >= 1");
        }
        if (highestTrackableValue < 2L * lowestTrackableValue) {
            throw new IllegalArgumentException("highestTrackableValue must be >= 2 * lowestTrackableValue");
        }
        if (numberOfSignificantValueDigits < 0 || numberOfSignificantValueDigits > 5) {
            throw new IllegalArgumentException("numberOfSignificantValueDigits must be between 0 and 6");
        }
        this.identity = constructionIdentityCount.getAndIncrement();
        this.init(lowestTrackableValue, highestTrackableValue, numberOfSignificantValueDigits, 0L);
    }

    private void init(long lowestTrackableValue, long highestTrackableValue, int numberOfSignificantValueDigits, long totalCount) {
        this.highestTrackableValue = highestTrackableValue;
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        this.lowestTrackableValue = lowestTrackableValue;
        long largestValueWithSingleUnitResolution = 2L * (long)Math.pow(10.0, numberOfSignificantValueDigits);
        this.unitMagnitude = (int)Math.floor(Math.log(lowestTrackableValue) / Math.log(2.0));
        int subBucketCountMagnitude = (int)Math.ceil(Math.log(largestValueWithSingleUnitResolution) / Math.log(2.0));
        this.subBucketHalfCountMagnitude = (subBucketCountMagnitude > 1 ? subBucketCountMagnitude : 1) - 1;
        this.subBucketCount = (int)Math.pow(2.0, this.subBucketHalfCountMagnitude + 1);
        this.subBucketHalfCount = this.subBucketCount / 2;
        this.subBucketMask = this.subBucketCount - 1 << this.unitMagnitude;
        this.bucketCount = this.getBucketsNeededToCoverValue(highestTrackableValue);
        this.countsArrayLength = this.getLengthForNumberOfBuckets(this.bucketCount);
        this.setTotalCount(totalCount);
        this.histogramData = new HistogramData(this);
    }

    int getBucketsNeededToCoverValue(long value) {
        long trackableValue = this.subBucketCount - 1 << this.unitMagnitude;
        int bucketsNeeded = 1;
        while (trackableValue < value) {
            trackableValue <<= 1;
            ++bucketsNeeded;
        }
        return bucketsNeeded;
    }

    int getLengthForNumberOfBuckets(int numberOfBuckets) {
        int lengthNeeded = (numberOfBuckets + 1) * (this.subBucketCount / 2);
        return lengthNeeded;
    }

    public long getLowestTrackableValue() {
        return this.lowestTrackableValue;
    }

    public long getHighestTrackableValue() {
        return this.highestTrackableValue;
    }

    public int getNumberOfSignificantValueDigits() {
        return this.numberOfSignificantValueDigits;
    }

    public long getStartTimeStamp() {
        return this.startTimeStampMsec;
    }

    public void setStartTimeStamp(long timeStampMsec) {
        this.startTimeStampMsec = timeStampMsec;
    }

    public long getEndTimeStamp() {
        return this.endTimeStampMsec;
    }

    public void setEndTimeStamp(long timeStampMsec) {
        this.endTimeStampMsec = timeStampMsec;
    }

    private int countsArrayIndex(int bucketIndex, int subBucketIndex) {
        assert (subBucketIndex < this.subBucketCount);
        assert (bucketIndex == 0 || subBucketIndex >= this.subBucketHalfCount);
        int bucketBaseIndex = bucketIndex + 1 << this.subBucketHalfCountMagnitude;
        int offsetInBucket = subBucketIndex - this.subBucketHalfCount;
        return bucketBaseIndex + offsetInBucket;
    }

    long getCountAt(int bucketIndex, int subBucketIndex) {
        return this.getCountAtIndex(this.countsArrayIndex(bucketIndex, subBucketIndex));
    }

    int getBucketIndex(long value) {
        int pow2ceiling = 64 - Long.numberOfLeadingZeros(value | this.subBucketMask);
        return pow2ceiling - this.unitMagnitude - (this.subBucketHalfCountMagnitude + 1);
    }

    int getSubBucketIndex(long value, int bucketIndex) {
        return (int)(value >> bucketIndex + this.unitMagnitude);
    }

    private void recordCountAtValue(long count, long value) throws ArrayIndexOutOfBoundsException {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        int countsIndex = this.countsArrayIndex(bucketIndex, subBucketIndex);
        this.addToCountAtIndex(countsIndex, count);
        this.addToTotalCount(count);
    }

    private void recordSingleValue(long value) throws ArrayIndexOutOfBoundsException {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        int countsIndex = this.countsArrayIndex(bucketIndex, subBucketIndex);
        this.incrementCountAtIndex(countsIndex);
        this.incrementTotalCount();
    }

    private void recordValueWithCountAndExpectedInterval(long value, long count, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordCountAtValue(count, value);
        if (expectedIntervalBetweenValueSamples <= 0L) {
            return;
        }
        for (long missingValue = value - expectedIntervalBetweenValueSamples; missingValue >= expectedIntervalBetweenValueSamples; missingValue -= expectedIntervalBetweenValueSamples) {
            this.recordCountAtValue(count, missingValue);
        }
    }

    public void recordValueWithExpectedInterval(long value, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordValueWithCountAndExpectedInterval(value, 1L, expectedIntervalBetweenValueSamples);
    }

    public void recordValue(long value, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
    }

    public void recordValueWithCount(long value, long count) throws ArrayIndexOutOfBoundsException {
        this.recordCountAtValue(count, value);
    }

    public void recordValue(long value) throws ArrayIndexOutOfBoundsException {
        this.recordSingleValue(value);
    }

    public void reset() {
        this.clearCounts();
    }

    public void add(AbstractHistogram fromHistogram) throws ArrayIndexOutOfBoundsException {
        if (this.highestTrackableValue < fromHistogram.highestTrackableValue) {
            throw new ArrayIndexOutOfBoundsException("The other histogram covers a wider range than this one.");
        }
        if (this.bucketCount == fromHistogram.bucketCount && this.subBucketCount == fromHistogram.subBucketCount && this.unitMagnitude == fromHistogram.unitMagnitude) {
            for (int i = 0; i < fromHistogram.countsArrayLength; ++i) {
                this.addToCountAtIndex(i, fromHistogram.getCountAtIndex(i));
            }
            this.setTotalCount(this.getTotalCount() + fromHistogram.getTotalCount());
        } else {
            for (int i = 0; i < fromHistogram.countsArrayLength; ++i) {
                long count = fromHistogram.getCountAtIndex(i);
                this.recordValueWithCount(fromHistogram.valueFromIndex(i), count);
            }
        }
    }

    public void addWhileCorrectingForCoordinatedOmission(AbstractHistogram fromHistogram, long expectedIntervalBetweenValueSamples) {
        AbstractHistogram toHistogram = this;
        for (HistogramIterationValue v : fromHistogram.getHistogramData().recordedValues()) {
            toHistogram.recordValueWithCountAndExpectedInterval(v.getValueIteratedTo(), v.getCountAtValueIteratedTo(), expectedIntervalBetweenValueSamples);
        }
    }

    public boolean hasOverflowed() {
        long totalCounted = 0L;
        for (int i = 0; i < this.countsArrayLength; ++i) {
            totalCounted += this.getCountAtIndex(i);
        }
        return totalCounted != this.getTotalCount();
    }

    public void reestablishTotalCount() {
        long totalCounted = 0L;
        for (int i = 0; i < this.countsArrayLength; ++i) {
            totalCounted += this.getCountAtIndex(i);
        }
        this.setTotalCount(totalCounted);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractHistogram)) {
            return false;
        }
        AbstractHistogram that = (AbstractHistogram)other;
        if (this.highestTrackableValue != that.highestTrackableValue || this.numberOfSignificantValueDigits != that.numberOfSignificantValueDigits) {
            return false;
        }
        if (this.countsArrayLength != that.countsArrayLength) {
            return false;
        }
        if (this.getTotalCount() != that.getTotalCount()) {
            return false;
        }
        for (int i = 0; i < this.countsArrayLength; ++i) {
            if (this.getCountAtIndex(i) == that.getCountAtIndex(i)) continue;
            return false;
        }
        return true;
    }

    public HistogramData getHistogramData() {
        return this.histogramData;
    }

    public long sizeOfEquivalentValueRange(long value) {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        long distanceToNextValue = 1 << this.unitMagnitude + (subBucketIndex >= this.subBucketCount ? bucketIndex + 1 : bucketIndex);
        return distanceToNextValue;
    }

    public long lowestEquivalentValue(long value) {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        long thisValueBaseLevel = this.valueFromIndex(bucketIndex, subBucketIndex);
        return thisValueBaseLevel;
    }

    public long highestEquivalentValue(long value) {
        return this.nextNonEquivalentValue(value) - 1L;
    }

    public long medianEquivalentValue(long value) {
        return this.lowestEquivalentValue(value) + (this.sizeOfEquivalentValueRange(value) >> 1);
    }

    public long nextNonEquivalentValue(long value) {
        return this.lowestEquivalentValue(value) + this.sizeOfEquivalentValueRange(value);
    }

    public boolean valuesAreEquivalent(long value1, long value2) {
        return this.lowestEquivalentValue(value1) == this.lowestEquivalentValue(value2);
    }

    private void writeObject(ObjectOutputStream o) throws IOException {
        o.writeLong(this.lowestTrackableValue);
        o.writeLong(this.highestTrackableValue);
        o.writeInt(this.numberOfSignificantValueDigits);
        o.writeLong(this.getTotalCount());
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        long lowestTrackableValue = o.readLong();
        long highestTrackableValue = o.readLong();
        int numberOfSignificantValueDigits = o.readInt();
        long totalCount = o.readLong();
        this.init(lowestTrackableValue, highestTrackableValue, numberOfSignificantValueDigits, totalCount);
        this.setTotalCount(totalCount);
    }

    public int getNeededByteBufferCapacity() {
        return this.getNeededByteBufferCapacity(this.countsArrayLength);
    }

    private int getNeededByteBufferCapacity(int relevantLength) {
        return relevantLength * this.wordSizeInBytes + 32;
    }

    abstract void fillCountsArrayFromBuffer(ByteBuffer var1, int var2);

    abstract void fillBufferFromCountsArray(ByteBuffer var1, int var2);

    private int getEncodingCookie() {
        return 478450440 + (this.wordSizeInBytes << 4);
    }

    private int getCompressedEncodingCookie() {
        return 478450441 + (this.wordSizeInBytes << 4);
    }

    private static int getCookieBase(int cookie) {
        return cookie & 0xFFFFFF0F;
    }

    private static int getWordSizeInBytesFromCookie(int cookie) {
        return (cookie & 0xF0) >> 4;
    }

    public synchronized int encodeIntoByteBuffer(ByteBuffer buffer) {
        long maxValue = this.getHistogramData().getMaxValue();
        int relevantLength = this.getLengthForNumberOfBuckets(this.getBucketsNeededToCoverValue(maxValue));
        if (buffer.capacity() < this.getNeededByteBufferCapacity(relevantLength)) {
            throw new ArrayIndexOutOfBoundsException("buffer does not have capacity for" + this.getNeededByteBufferCapacity(relevantLength) + " bytes");
        }
        buffer.putInt(this.getEncodingCookie());
        buffer.putInt(this.numberOfSignificantValueDigits);
        buffer.putLong(this.lowestTrackableValue);
        buffer.putLong(this.highestTrackableValue);
        buffer.putLong(this.getTotalCount());
        this.fillBufferFromCountsArray(buffer, relevantLength);
        return this.getNeededByteBufferCapacity(relevantLength);
    }

    public synchronized int encodeIntoCompressedByteBuffer(ByteBuffer targetBuffer, int compressionLevel) {
        if (this.intermediateUncompressedByteBuffer == null) {
            this.intermediateUncompressedByteBuffer = ByteBuffer.allocate(this.getNeededByteBufferCapacity(this.countsArrayLength));
        }
        this.intermediateUncompressedByteBuffer.clear();
        int uncompressedLength = this.encodeIntoByteBuffer(this.intermediateUncompressedByteBuffer);
        targetBuffer.putInt(this.getCompressedEncodingCookie());
        targetBuffer.putInt(0);
        Deflater compressor = new Deflater(compressionLevel);
        compressor.setInput(this.intermediateUncompressedByteBuffer.array(), 0, uncompressedLength);
        compressor.finish();
        byte[] targetArray = targetBuffer.array();
        int compressedDataLength = compressor.deflate(targetArray, 8, targetArray.length - 8);
        compressor.end();
        targetBuffer.putInt(4, compressedDataLength);
        return compressedDataLength + 8;
    }

    public int encodeIntoCompressedByteBuffer(ByteBuffer targetBuffer) {
        return this.encodeIntoCompressedByteBuffer(targetBuffer, -1);
    }

    static AbstractHistogram constructHistogramFromBufferHeader(ByteBuffer buffer, Class histogramClass, long minBarForHighestTrackableValue) {
        int cookie = buffer.getInt();
        if (AbstractHistogram.getCookieBase(cookie) != 478450440) {
            throw new IllegalArgumentException("The buffer does not contain a Histogram");
        }
        int numberOfSignificantValueDigits = buffer.getInt();
        long lowestTrackableValue = buffer.getLong();
        long highestTrackableValue = buffer.getLong();
        long totalCount = buffer.getLong();
        highestTrackableValue = Math.max(highestTrackableValue, minBarForHighestTrackableValue);
        try {
            Constructor constructor = histogramClass.getConstructor(constructorArgsTypes);
            AbstractHistogram histogram = (AbstractHistogram)constructor.newInstance(lowestTrackableValue, highestTrackableValue, numberOfSignificantValueDigits);
            histogram.setTotalCount(totalCount);
            if (cookie != histogram.getEncodingCookie()) {
                throw new IllegalArgumentException("The buffer's encoded value byte size (" + AbstractHistogram.getWordSizeInBytesFromCookie(cookie) + ") does not match the Histogram's (" + histogram.wordSizeInBytes + ")");
            }
            return histogram;
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static AbstractHistogram decodeFromByteBuffer(ByteBuffer buffer, Class histogramClass, long minBarForHighestTrackableValue) {
        AbstractHistogram histogram = AbstractHistogram.constructHistogramFromBufferHeader(buffer, histogramClass, minBarForHighestTrackableValue);
        int expectedCapacity = histogram.getNeededByteBufferCapacity(histogram.countsArrayLength);
        if (expectedCapacity > buffer.capacity()) {
            throw new IllegalArgumentException("The buffer does not contain the full Histogram");
        }
        histogram.fillCountsArrayFromBuffer(buffer, histogram.countsArrayLength);
        return histogram;
    }

    static AbstractHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, Class histogramClass, long minBarForHighestTrackableValue) throws DataFormatException {
        int cookie = buffer.getInt();
        if (AbstractHistogram.getCookieBase(cookie) != 478450441) {
            throw new IllegalArgumentException("The buffer does not contain a compressed Histogram");
        }
        int lengthOfCompressedContents = buffer.getInt();
        Inflater decompressor = new Inflater();
        decompressor.setInput(buffer.array(), 8, lengthOfCompressedContents);
        ByteBuffer headerBuffer = ByteBuffer.allocate(32);
        decompressor.inflate(headerBuffer.array());
        AbstractHistogram histogram = AbstractHistogram.constructHistogramFromBufferHeader(headerBuffer, histogramClass, minBarForHighestTrackableValue);
        ByteBuffer countsBuffer = ByteBuffer.allocate(histogram.getNeededByteBufferCapacity(histogram.countsArrayLength) - 32);
        decompressor.inflate(countsBuffer.array());
        histogram.fillCountsArrayFromBuffer(countsBuffer, histogram.countsArrayLength);
        return histogram;
    }

    final long valueFromIndex(int bucketIndex, int subBucketIndex) {
        return (long)subBucketIndex << bucketIndex + this.unitMagnitude;
    }

    final long valueFromIndex(int index) {
        int bucketIndex = (index >> this.subBucketHalfCountMagnitude) - 1;
        int subBucketIndex = (index & this.subBucketHalfCount - 1) + this.subBucketHalfCount;
        if (bucketIndex < 0) {
            subBucketIndex -= this.subBucketHalfCount;
            bucketIndex = 0;
        }
        return this.valueFromIndex(bucketIndex, subBucketIndex);
    }
}

