/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Locale;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.AllValuesIterator;
import org.HdrHistogram.HistogramIterationValue;
import org.HdrHistogram.LinearIterator;
import org.HdrHistogram.LogarithmicIterator;
import org.HdrHistogram.PercentileIterator;
import org.HdrHistogram.RecordedValuesIterator;

public class HistogramData {
    final AbstractHistogram histogram;
    final PercentileIterator percentileIterator;
    final RecordedValuesIterator recordedValuesIterator;
    final int bucketCount;
    final int subBucketCount;

    HistogramData(AbstractHistogram histogram) {
        this.histogram = histogram;
        this.percentileIterator = new PercentileIterator(histogram, 1);
        this.recordedValuesIterator = new RecordedValuesIterator(histogram);
        this.bucketCount = histogram.bucketCount;
        this.subBucketCount = histogram.subBucketCount;
    }

    public long getTotalCount() {
        return this.histogram.getTotalCount();
    }

    public long getMinValue() {
        this.recordedValuesIterator.reset();
        long min = 0L;
        if (this.recordedValuesIterator.hasNext()) {
            HistogramIterationValue iterationValue = this.recordedValuesIterator.next();
            min = iterationValue.getValueIteratedTo();
        }
        return this.histogram.lowestEquivalentValue(min);
    }

    public long getMaxValue() {
        this.recordedValuesIterator.reset();
        long max = 0L;
        while (this.recordedValuesIterator.hasNext()) {
            HistogramIterationValue iterationValue = this.recordedValuesIterator.next();
            max = iterationValue.getValueIteratedTo();
        }
        return this.histogram.lowestEquivalentValue(max);
    }

    public double getMean() {
        this.recordedValuesIterator.reset();
        long totalValue = 0L;
        while (this.recordedValuesIterator.hasNext()) {
            HistogramIterationValue iterationValue = this.recordedValuesIterator.next();
            totalValue = iterationValue.getTotalValueToThisValue();
        }
        return (double)totalValue * 1.0 / (double)this.getTotalCount();
    }

    public double getStdDeviation() {
        double mean = this.getMean();
        double geometric_deviation_total = 0.0;
        this.recordedValuesIterator.reset();
        while (this.recordedValuesIterator.hasNext()) {
            HistogramIterationValue iterationValue = this.recordedValuesIterator.next();
            Double deviation = (double)this.histogram.medianEquivalentValue(iterationValue.getValueIteratedTo()) * 1.0 - mean;
            geometric_deviation_total += deviation * deviation * (double)iterationValue.getCountAddedInThisIterationStep();
        }
        double std_deviation = Math.sqrt(geometric_deviation_total / (double)this.getTotalCount());
        return std_deviation;
    }

    public long getValueAtPercentile(double percentile) {
        double requestedPercentile = Math.min(percentile, 100.0);
        long countAtPercentile = (long)(requestedPercentile / 100.0 * (double)this.getTotalCount() + 0.5);
        countAtPercentile = Math.max(countAtPercentile, 1L);
        long totalToCurrentIJ = 0L;
        for (int i = 0; i < this.bucketCount; ++i) {
            int j;
            int n = j = i == 0 ? 0 : this.subBucketCount / 2;
            while (j < this.subBucketCount) {
                if ((totalToCurrentIJ += this.histogram.getCountAt(i, j)) >= countAtPercentile) {
                    long valueAtIndex = this.histogram.valueFromIndex(i, j);
                    return valueAtIndex;
                }
                ++j;
            }
        }
        throw new ArrayIndexOutOfBoundsException("percentile value not found in range");
    }

    public double getPercentileAtOrBelowValue(long value) {
        long totalToCurrentIJ = 0L;
        int targetBucketIndex = this.histogram.getBucketIndex(value);
        int targetSubBucketIndex = this.histogram.getSubBucketIndex(value, targetBucketIndex);
        if (targetBucketIndex >= this.bucketCount) {
            return 100.0;
        }
        for (int i = 0; i <= targetBucketIndex; ++i) {
            int subBucketCap;
            int n = subBucketCap = i == targetBucketIndex ? targetSubBucketIndex + 1 : this.subBucketCount;
            for (int j = i == 0 ? 0 : this.subBucketCount / 2; j < subBucketCap; ++j) {
                totalToCurrentIJ += this.histogram.getCountAt(i, j);
            }
        }
        return 100.0 * (double)totalToCurrentIJ / (double)this.getTotalCount();
    }

    public long getCountBetweenValues(long lowValue, long highValue) throws ArrayIndexOutOfBoundsException {
        long count = 0L;
        int lowBucketIndex = this.histogram.getBucketIndex(lowValue);
        int lowSubBucketIndex = this.histogram.getSubBucketIndex(lowValue, lowBucketIndex);
        long valueAtlowValue = this.histogram.valueFromIndex(lowBucketIndex, lowSubBucketIndex);
        int highBucketIndex = this.histogram.getBucketIndex(highValue);
        int highSubBucketIndex = this.histogram.getSubBucketIndex(highValue, highBucketIndex);
        long valueAtHighValue = this.histogram.valueFromIndex(highBucketIndex, highSubBucketIndex);
        if (lowBucketIndex >= this.bucketCount || highBucketIndex >= this.bucketCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = lowBucketIndex; i <= highBucketIndex; ++i) {
            int j;
            int n = j = i == 0 ? 0 : this.subBucketCount / 2;
            while (j < this.subBucketCount) {
                long valueAtIndex = this.histogram.valueFromIndex(i, j);
                if (valueAtIndex > valueAtHighValue) {
                    return count;
                }
                if (valueAtIndex >= valueAtlowValue) {
                    count += this.histogram.getCountAt(i, j);
                }
                ++j;
            }
        }
        return count;
    }

    public long getCountAtValue(long value) throws ArrayIndexOutOfBoundsException {
        int bucketIndex = this.histogram.getBucketIndex(value);
        int subBucketIndex = this.histogram.getSubBucketIndex(value, bucketIndex);
        return this.histogram.getCountAt(bucketIndex, subBucketIndex);
    }

    public Percentiles percentiles(int percentileTicksPerHalfDistance) {
        return new Percentiles(this.histogram, percentileTicksPerHalfDistance);
    }

    public LinearBucketValues linearBucketValues(int valueUnitsPerBucket) {
        return new LinearBucketValues(this.histogram, valueUnitsPerBucket);
    }

    public LogarithmicBucketValues logarithmicBucketValues(int valueUnitsInFirstBucket, double logBase) {
        return new LogarithmicBucketValues(this.histogram, valueUnitsInFirstBucket, logBase);
    }

    public RecordedValues recordedValues() {
        return new RecordedValues(this.histogram);
    }

    public AllValues allValues() {
        return new AllValues(this.histogram);
    }

    public void outputPercentileDistribution(PrintStream printStream, Double outputValueUnitScalingRatio) {
        this.outputPercentileDistribution(printStream, 5, outputValueUnitScalingRatio);
    }

    public void outputPercentileDistribution(PrintStream printStream, int percentileTicksPerHalfDistance, Double outputValueUnitScalingRatio) {
        this.outputPercentileDistribution(printStream, percentileTicksPerHalfDistance, outputValueUnitScalingRatio, false);
    }

    public void outputPercentileDistribution(PrintStream printStream, int percentileTicksPerHalfDistance, Double outputValueUnitScalingRatio, boolean useCsvFormat) {
        String lastLinePercentileFormatString;
        String percentileFormatString;
        if (useCsvFormat) {
            printStream.format("\"Value\",\"Percentile\",\"TotalCount\",\"1/(1-Percentile)\"\n", new Object[0]);
        } else {
            printStream.format("%12s %14s %10s %14s\n\n", "Value", "Percentile", "TotalCount", "1/(1-Percentile)");
        }
        PercentileIterator iterator = this.percentileIterator;
        iterator.reset(percentileTicksPerHalfDistance);
        if (useCsvFormat) {
            percentileFormatString = "%." + this.histogram.numberOfSignificantValueDigits + "f,%.12f,%d,%.2f\n";
            lastLinePercentileFormatString = "%." + this.histogram.numberOfSignificantValueDigits + "f,%.12f,%d,Infinity\n";
        } else {
            percentileFormatString = "%12." + this.histogram.numberOfSignificantValueDigits + "f %2.12f %10d %14.2f\n";
            lastLinePercentileFormatString = "%12." + this.histogram.numberOfSignificantValueDigits + "f %2.12f %10d\n";
        }
        try {
            while (iterator.hasNext()) {
                HistogramIterationValue iterationValue = iterator.next();
                if (iterationValue.getPercentileLevelIteratedTo() != 100.0) {
                    printStream.format(Locale.US, percentileFormatString, (double)iterationValue.getValueIteratedTo() / outputValueUnitScalingRatio, iterationValue.getPercentileLevelIteratedTo() / 100.0, iterationValue.getTotalCountToThisValue(), 1.0 / (1.0 - iterationValue.getPercentileLevelIteratedTo() / 100.0));
                    continue;
                }
                printStream.format(Locale.US, lastLinePercentileFormatString, (double)iterationValue.getValueIteratedTo() / outputValueUnitScalingRatio, iterationValue.getPercentileLevelIteratedTo() / 100.0, iterationValue.getTotalCountToThisValue());
            }
            if (!useCsvFormat) {
                double mean = this.getMean() / outputValueUnitScalingRatio;
                double std_deviation = this.getStdDeviation() / outputValueUnitScalingRatio;
                printStream.format(Locale.US, "#[Mean    = %12." + this.histogram.numberOfSignificantValueDigits + "f, StdDeviation   = %12." + this.histogram.numberOfSignificantValueDigits + "f]\n", mean, std_deviation);
                printStream.format(Locale.US, "#[Max     = %12." + this.histogram.numberOfSignificantValueDigits + "f, Total count    = %12d]\n", (double)this.getMaxValue() / outputValueUnitScalingRatio, this.getTotalCount());
                printStream.format(Locale.US, "#[Buckets = %12d, SubBuckets     = %12d]\n", this.histogram.bucketCount, this.histogram.subBucketCount);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (this.histogram.hasOverflowed()) {
                printStream.format(Locale.US, "# Histogram counts indicate OVERFLOW values", new Object[0]);
            }
            throw e;
        }
    }

    public class AllValues
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;

        private AllValues(AbstractHistogram histogram) {
            this.histogram = histogram;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new AllValuesIterator(this.histogram);
        }
    }

    public class RecordedValues
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;

        private RecordedValues(AbstractHistogram histogram) {
            this.histogram = histogram;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new RecordedValuesIterator(this.histogram);
        }
    }

    public class LogarithmicBucketValues
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;
        final int valueUnitsInFirstBucket;
        final double logBase;

        private LogarithmicBucketValues(AbstractHistogram histogram, int valueUnitsInFirstBucket, double logBase) {
            this.histogram = histogram;
            this.valueUnitsInFirstBucket = valueUnitsInFirstBucket;
            this.logBase = logBase;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new LogarithmicIterator(this.histogram, this.valueUnitsInFirstBucket, this.logBase);
        }
    }

    public class LinearBucketValues
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;
        final int valueUnitsPerBucket;

        private LinearBucketValues(AbstractHistogram histogram, int valueUnitsPerBucket) {
            this.histogram = histogram;
            this.valueUnitsPerBucket = valueUnitsPerBucket;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new LinearIterator(this.histogram, this.valueUnitsPerBucket);
        }
    }

    public class Percentiles
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;
        final int percentileTicksPerHalfDistance;

        private Percentiles(AbstractHistogram histogram, int percentileTicksPerHalfDistance) {
            this.histogram = histogram;
            this.percentileTicksPerHalfDistance = percentileTicksPerHalfDistance;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new PercentileIterator(this.histogram, this.percentileTicksPerHalfDistance);
        }
    }
}

