/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import org.HdrHistogram.Histogram;

public class HistogramLogWriter {
    private static final String HISTOGRAM_LOG_FORMAT_VERSION = "1.01";
    private final PrintStream log;
    private ByteBuffer targetBuffer;

    public HistogramLogWriter(String outputFileName) throws FileNotFoundException {
        this.log = new PrintStream(outputFileName);
    }

    public HistogramLogWriter(File outputFile) throws FileNotFoundException {
        this.log = new PrintStream(outputFile);
    }

    public HistogramLogWriter(OutputStream outputStream) throws FileNotFoundException {
        this.log = new PrintStream(outputStream);
    }

    public HistogramLogWriter(PrintStream printStream) throws FileNotFoundException {
        this.log = printStream;
    }

    public void outputIntervalHistogram(double startTimeStampSec, double endTimeStampSec, Histogram histogram) {
        if (this.targetBuffer == null || this.targetBuffer.capacity() < histogram.getNeededByteBufferCapacity()) {
            this.targetBuffer = ByteBuffer.allocate(histogram.getNeededByteBufferCapacity());
        }
        this.targetBuffer.clear();
        int compressedLength = histogram.encodeIntoCompressedByteBuffer(this.targetBuffer, 9);
        byte[] compressedArray = Arrays.copyOf(this.targetBuffer.array(), compressedLength);
        this.log.format(Locale.US, "%.3f,%.3f,%.3f,%s\n", startTimeStampSec, endTimeStampSec - startTimeStampSec, (double)histogram.getHistogramData().getMaxValue() / 1000000.0, DatatypeConverter.printBase64Binary((byte[])compressedArray));
    }

    public void outputIntervalHistogram(Histogram histogram) {
        this.outputIntervalHistogram((double)histogram.getStartTimeStamp() / 1000.0, (double)histogram.getEndTimeStamp() / 1000.0, histogram);
    }

    public void outputStartTime(long startTimeMsec) {
        this.log.format(Locale.US, "#[StartTime: %.3f (seconds since epoch), %s]\n", (double)startTimeMsec / 1000.0, new Date(startTimeMsec).toString());
    }

    public void outputComment(String comment) {
        this.log.format("#%s\n", comment);
    }

    public void outputLegend() {
        this.log.println("\"StartTimestamp\",\"EndTimestamp\",\"Interval_Max\",\"Interval_Compressed_Histogram\"");
    }

    public void outputLogFormatVersion() {
        this.outputComment("[Histogram log format version 1.01]");
    }
}

