/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import org.HdrHistogram.AbstractHistogram;

public class IntHistogram
extends AbstractHistogram {
    long totalCount;
    final int[] counts = new int[this.countsArrayLength];
    private IntBuffer cachedDstIntBuffer = null;
    private ByteBuffer cachedDstByteBuffer = null;
    private int cachedDstByteBufferPosition = 0;

    @Override
    long getCountAtIndex(int index) {
        return this.counts[index];
    }

    @Override
    void incrementCountAtIndex(int index) {
        int n = index;
        this.counts[n] = this.counts[n] + 1;
    }

    @Override
    void addToCountAtIndex(int index, long value) {
        int n = index;
        this.counts[n] = (int)((long)this.counts[n] + value);
    }

    @Override
    void clearCounts() {
        Arrays.fill(this.counts, 0);
        this.totalCount = 0L;
    }

    @Override
    public IntHistogram copy() {
        IntHistogram copy = new IntHistogram(this);
        copy.add(this);
        return copy;
    }

    @Override
    public IntHistogram copyCorrectedForCoordinatedOmission(long expectedIntervalBetweenValueSamples) {
        IntHistogram toHistogram = new IntHistogram(this);
        toHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
        return toHistogram;
    }

    @Override
    long getTotalCount() {
        return this.totalCount;
    }

    @Override
    void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    @Override
    void incrementTotalCount() {
        ++this.totalCount;
    }

    @Override
    void addToTotalCount(long value) {
        this.totalCount += value;
    }

    @Override
    int _getEstimatedFootprintInBytes() {
        return 512 + 4 * this.counts.length;
    }

    public IntHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(1L, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public IntHistogram(long lowestTrackableValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        super(lowestTrackableValue, highestTrackableValue, numberOfSignificantValueDigits);
        this.wordSizeInBytes = 4;
    }

    private IntHistogram(AbstractHistogram source) {
        super(source);
        this.wordSizeInBytes = 4;
    }

    public static IntHistogram decodeFromByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) {
        return (IntHistogram)IntHistogram.decodeFromByteBuffer(buffer, IntHistogram.class, minBarForHighestTrackableValue);
    }

    public static IntHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) throws DataFormatException {
        return (IntHistogram)IntHistogram.decodeFromCompressedByteBuffer(buffer, IntHistogram.class, minBarForHighestTrackableValue);
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        o.defaultReadObject();
    }

    @Override
    synchronized void fillCountsArrayFromBuffer(ByteBuffer buffer, int length) {
        buffer.asIntBuffer().get(this.counts, 0, length);
    }

    @Override
    synchronized void fillBufferFromCountsArray(ByteBuffer buffer, int length) {
        if (this.cachedDstIntBuffer == null || buffer != this.cachedDstByteBuffer || buffer.position() != this.cachedDstByteBufferPosition) {
            this.cachedDstByteBuffer = buffer;
            this.cachedDstByteBufferPosition = buffer.position();
            this.cachedDstIntBuffer = buffer.asIntBuffer();
        }
        this.cachedDstIntBuffer.rewind();
        this.cachedDstIntBuffer.put(this.counts, 0, length);
    }
}

