/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import org.HdrHistogram.AbstractHistogram;

public class IntCountsHistogram
extends AbstractHistogram {
    long totalCount;
    final int[] counts = new int[this.countsArrayLength];
    private IntBuffer cachedDstIntBuffer = null;
    private ByteBuffer cachedDstByteBuffer = null;
    private int cachedDstByteBufferPosition = 0;

    @Override
    long getCountAtNormalizedIndex(int index) {
        return this.counts[index];
    }

    @Override
    void incrementCountAtNormalizedIndex(int index) {
        int currentCount = this.counts[index];
        int newCount = currentCount + 1;
        if (newCount < 0) {
            throw new IllegalStateException("would overflow integer count");
        }
        this.counts[index] = newCount;
    }

    @Override
    void addToCountAtNormalizedIndex(int index, long value) {
        int currentCount = this.counts[index];
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("would overflow short integer count");
        }
        int newCount = (int)((long)currentCount + value);
        if (newCount < 0) {
            throw new IllegalStateException("would overflow short integer count");
        }
        this.counts[index] = newCount;
    }

    @Override
    void setCountAtNormalizedIndex(int index, long value) {
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("would overflow short integer count");
        }
        this.counts[index] = (int)value;
    }

    @Override
    void clearCounts() {
        Arrays.fill(this.counts, 0);
        this.totalCount = 0L;
    }

    @Override
    public IntCountsHistogram copy() {
        IntCountsHistogram copy = new IntCountsHistogram(this);
        copy.add(this);
        return copy;
    }

    @Override
    public IntCountsHistogram copyCorrectedForCoordinatedOmission(long expectedIntervalBetweenValueSamples) {
        IntCountsHistogram toHistogram = new IntCountsHistogram(this);
        toHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
        return toHistogram;
    }

    @Override
    public long getTotalCount() {
        return this.totalCount;
    }

    @Override
    void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }

    @Override
    void incrementTotalCount() {
        ++this.totalCount;
    }

    @Override
    void addToTotalCount(long value) {
        this.totalCount += value;
    }

    @Override
    int _getEstimatedFootprintInBytes() {
        return 512 + 4 * this.counts.length;
    }

    public IntCountsHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(1L, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public IntCountsHistogram(long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        super(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits);
        this.wordSizeInBytes = 4;
    }

    public IntCountsHistogram(AbstractHistogram source) {
        super(source);
        this.wordSizeInBytes = 4;
    }

    public static IntCountsHistogram decodeFromByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) {
        return (IntCountsHistogram)IntCountsHistogram.decodeFromByteBuffer(buffer, IntCountsHistogram.class, minBarForHighestTrackableValue);
    }

    public static IntCountsHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) throws DataFormatException {
        return (IntCountsHistogram)IntCountsHistogram.decodeFromCompressedByteBuffer(buffer, IntCountsHistogram.class, minBarForHighestTrackableValue);
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        o.defaultReadObject();
    }

    @Override
    synchronized void fillCountsArrayFromBuffer(ByteBuffer buffer, int length) {
        buffer.asIntBuffer().get(this.counts, 0, length);
    }

    @Override
    synchronized void fillBufferFromCountsArray(ByteBuffer buffer, int length) {
        if (this.cachedDstIntBuffer == null || buffer != this.cachedDstByteBuffer || buffer.position() != this.cachedDstByteBufferPosition) {
            this.cachedDstByteBuffer = buffer;
            this.cachedDstByteBufferPosition = buffer.position();
            this.cachedDstIntBuffer = buffer.asIntBuffer();
        }
        this.cachedDstIntBuffer.rewind();
        this.cachedDstIntBuffer.put(this.counts, 0, length);
    }
}

