/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.connection.ConcurrentHClientPool;
import me.prettyprint.cassandra.connection.client.HClient;
import me.prettyprint.cassandra.connection.factory.HClientFactory;
import me.prettyprint.cassandra.connection.factory.HThriftClientFactoryImpl;
import me.prettyprint.cassandra.service.CassandraClientMonitor;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.hector.api.exceptions.HInactivePoolException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConcurrentHClientPoolTest
extends BaseEmbededServerSetupTest {
    private CassandraHost cassandraHost;
    private ConcurrentHClientPool clientPool;

    @Before
    public void setupTest() {
        this.setupClient();
        this.cassandraHost = this.cassandraHostConfigurator.buildCassandraHosts()[0];
        HThriftClientFactoryImpl factory = new HThriftClientFactoryImpl();
        this.clientPool = new ConcurrentHClientPool((HClientFactory)factory, this.cassandraHost, new CassandraClientMonitor(this.connectionManager));
    }

    @Test
    public void testSpinUp() {
        Assert.assertEquals((long)16L, (long)this.clientPool.getNumIdle());
        Assert.assertEquals((long)50L, (long)this.clientPool.getNumBeforeExhausted());
        Assert.assertEquals((long)0L, (long)this.clientPool.getNumBlockedThreads());
        Assert.assertEquals((long)0L, (long)this.clientPool.getNumActive());
    }

    @Test
    public void testShutdown() {
        this.clientPool.shutdown();
        Assert.assertEquals((long)0L, (long)this.clientPool.getNumIdle());
        Assert.assertEquals((long)0L, (long)this.clientPool.getNumBlockedThreads());
        Assert.assertEquals((long)0L, (long)this.clientPool.getNumActive());
        try {
            this.clientPool.borrowClient();
            Assert.fail();
        }
        catch (HInactivePoolException hInactivePoolException) {
            // empty catch block
        }
    }

    @Test
    public void testBorrowRelease() {
        HClient client = this.clientPool.borrowClient();
        Assert.assertEquals((long)1L, (long)this.clientPool.getNumActive());
        this.clientPool.releaseClient(client);
        Assert.assertEquals((long)0L, (long)this.clientPool.getNumActive());
    }
}

