/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import me.prettyprint.cassandra.connection.DynamicLoadBalancingPolicy;
import me.prettyprint.cassandra.connection.HClientPool;
import me.prettyprint.cassandra.connection.LatencyAwareHClientPool;
import me.prettyprint.cassandra.service.CassandraHost;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DynamicBalancingPolicyTest {
    private List<HClientPool> pools = new ArrayList<HClientPool>();
    private DynamicLoadBalancingPolicy dynBalancingPolicy;
    private LatencyAwareHClientPool poolWithScore5;
    private LatencyAwareHClientPool poolWithScore7;
    private LatencyAwareHClientPool poolWithScore10;

    @Before
    public void setup() {
        this.poolWithScore5 = (LatencyAwareHClientPool)Mockito.mock(LatencyAwareHClientPool.class);
        Mockito.when((Object)this.poolWithScore5.score()).thenReturn((Object)5.0);
        this.poolWithScore7 = (LatencyAwareHClientPool)Mockito.mock(LatencyAwareHClientPool.class);
        Mockito.when((Object)this.poolWithScore7.score()).thenReturn((Object)7.0);
        this.poolWithScore10 = (LatencyAwareHClientPool)Mockito.mock(LatencyAwareHClientPool.class);
        Mockito.when((Object)this.poolWithScore10.score()).thenReturn((Object)10.0);
        Mockito.when((Object)this.poolWithScore5.getCassandraHost()).thenReturn((Object)new CassandraHost("127.0.0.1:9160"));
        Mockito.when((Object)this.poolWithScore7.getCassandraHost()).thenReturn((Object)new CassandraHost("127.0.0.2:9161"));
        Mockito.when((Object)this.poolWithScore10.getCassandraHost()).thenReturn((Object)new CassandraHost("127.0.0.3:9162"));
        this.pools.add((HClientPool)this.poolWithScore5);
        this.pools.add((HClientPool)this.poolWithScore7);
        this.pools.add((HClientPool)this.poolWithScore10);
    }

    @Test
    public void testGetPoolOk() {
        this.dynBalancingPolicy = new DynamicLoadBalancingPolicy();
        this.dynBalancingPolicy.add(this.poolWithScore10);
        this.dynBalancingPolicy.add(this.poolWithScore7);
        this.dynBalancingPolicy.add(this.poolWithScore5);
        this.dynBalancingPolicy.updateScores();
        Assert.assertEquals((Object)this.poolWithScore5, (Object)this.dynBalancingPolicy.getPool(this.pools, null));
        Assert.assertEquals((Object)this.poolWithScore5, (Object)this.dynBalancingPolicy.getPool(this.pools, null));
        Assert.assertEquals((Object)this.poolWithScore5, (Object)this.dynBalancingPolicy.getPool(this.pools, null));
        Mockito.when((Object)this.poolWithScore5.score()).thenReturn((Object)8.0);
        this.dynBalancingPolicy.updateScores();
        Assert.assertEquals((Object)this.poolWithScore7, (Object)this.dynBalancingPolicy.getPool(this.pools, null));
        Assert.assertEquals((Object)this.poolWithScore7, (Object)this.dynBalancingPolicy.getPool(this.pools, null));
        Assert.assertEquals((Object)this.poolWithScore7, (Object)this.dynBalancingPolicy.getPool(this.pools, null));
        Mockito.when((Object)this.poolWithScore10.score()).thenReturn((Object)4.0);
        this.dynBalancingPolicy.updateScores();
        Assert.assertEquals((Object)this.poolWithScore10, (Object)this.dynBalancingPolicy.getPool(this.pools, null));
        Assert.assertEquals((Object)this.poolWithScore10, (Object)this.dynBalancingPolicy.getPool(this.pools, null));
        Assert.assertEquals((Object)this.poolWithScore10, (Object)this.dynBalancingPolicy.getPool(this.pools, null));
    }

    @Test
    public void testSkipExhausted() {
        this.dynBalancingPolicy = new DynamicLoadBalancingPolicy();
        this.dynBalancingPolicy.add(this.poolWithScore10);
        Mockito.when((Object)this.poolWithScore10.score()).thenReturn((Object)100.0);
        Mockito.when((Object)this.poolWithScore10.getCassandraHost()).thenReturn((Object)new CassandraHost("127.0.0.3:9162"));
        this.dynBalancingPolicy.add(this.poolWithScore7);
        Mockito.when((Object)this.poolWithScore7.score()).thenReturn((Object)7.0);
        Mockito.when((Object)this.poolWithScore7.getCassandraHost()).thenReturn((Object)new CassandraHost("127.0.0.2:9161"));
        this.dynBalancingPolicy.add(this.poolWithScore5);
        Mockito.when((Object)this.poolWithScore5.score()).thenReturn((Object)5.0);
        Mockito.when((Object)this.poolWithScore5.getCassandraHost()).thenReturn((Object)new CassandraHost("127.0.0.1:9160"));
        this.dynBalancingPolicy.updateScores();
        Assert.assertEquals((Object)this.poolWithScore7, (Object)this.dynBalancingPolicy.getPool(this.pools, new HashSet<CassandraHost>(Arrays.asList(new CassandraHost("127.0.0.1:9160")))));
        Assert.assertEquals((Object)this.poolWithScore5, (Object)this.dynBalancingPolicy.getPool(this.pools, new HashSet<CassandraHost>(Arrays.asList(new CassandraHost("127.0.0.3:9162")))));
    }

    @Test
    public void testShuffleOnAllEqual() {
        DynamicLoadBalancingPolicy dbp = new DynamicLoadBalancingPolicy();
        LatencyAwareHClientPool poolWithScore2_1 = (LatencyAwareHClientPool)Mockito.mock(LatencyAwareHClientPool.class);
        Mockito.when((Object)poolWithScore2_1.score()).thenReturn((Object)2.0);
        Mockito.when((Object)poolWithScore2_1.getNumActive()).thenReturn((Object)5);
        Mockito.when((Object)poolWithScore2_1.getCassandraHost()).thenReturn((Object)new CassandraHost("127.0.0.4:9163"));
        LatencyAwareHClientPool poolWithScore2_2 = (LatencyAwareHClientPool)Mockito.mock(LatencyAwareHClientPool.class);
        Mockito.when((Object)poolWithScore2_2.score()).thenReturn((Object)2.0);
        Mockito.when((Object)poolWithScore2_2.getNumActive()).thenReturn((Object)5);
        Mockito.when((Object)poolWithScore2_2.getCassandraHost()).thenReturn((Object)new CassandraHost("127.0.0.5:9164"));
        LatencyAwareHClientPool poolWithScore2_3 = (LatencyAwareHClientPool)Mockito.mock(LatencyAwareHClientPool.class);
        Mockito.when((Object)poolWithScore2_3.score()).thenReturn((Object)2.0);
        Mockito.when((Object)poolWithScore2_3.getNumActive()).thenReturn((Object)5);
        Mockito.when((Object)poolWithScore2_3.getCassandraHost()).thenReturn((Object)new CassandraHost("127.0.0.6:9165"));
        ArrayList<LatencyAwareHClientPool> pool = new ArrayList<LatencyAwareHClientPool>();
        pool.add(poolWithScore2_1);
        pool.add(poolWithScore2_2);
        pool.add(poolWithScore2_3);
        dbp.add(poolWithScore2_1);
        dbp.add(poolWithScore2_2);
        dbp.add(poolWithScore2_3);
        dbp.updateScores();
        HashSet<CassandraHost> foundHosts = new HashSet<CassandraHost>();
        for (int i = 0; i < 50; ++i) {
            HClientPool foundPool = dbp.getPool(pool, null);
            CassandraHost p = foundPool.getCassandraHost();
            foundHosts.add(p);
            assert (5 == foundPool.getNumActive());
        }
        Assert.assertEquals((long)3L, (long)foundHosts.size());
    }
}

