/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.connection.ConcurrentHClientPool;
import me.prettyprint.cassandra.connection.client.HClient;
import me.prettyprint.cassandra.connection.factory.HClientFactory;
import me.prettyprint.cassandra.connection.factory.HThriftClientFactoryImpl;
import me.prettyprint.cassandra.service.CassandraClientMonitor;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HClientIdleConnectionRenewTest
extends BaseEmbededServerSetupTest {
    private CassandraHost cassandraHost;
    private ConcurrentHClientPool clientPool;
    private CassandraClientMonitor monitor;

    @Before
    public void setupTest() {
        this.setupClient();
        this.cassandraHost = this.cassandraHostConfigurator.buildCassandraHosts()[0];
        HThriftClientFactoryImpl factory = new HThriftClientFactoryImpl();
        this.monitor = new CassandraClientMonitor(this.connectionManager);
        this.clientPool = new ConcurrentHClientPool((HClientFactory)factory, this.cassandraHost, this.monitor);
    }

    @Override
    protected void configure(CassandraHostConfigurator configurator) {
        configurator.setMaxActive(1);
        configurator.setMaxLastSuccessTimeMillis(3000L);
    }

    @Test
    public void testBorrowAndRenew() {
        HClient client1 = this.clientPool.borrowClient();
        Assert.assertEquals((long)1L, (long)this.clientPool.getNumActive());
        client1.updateLastSuccessTime();
        this.clientPool.releaseClient(client1);
        Assert.assertEquals((long)0L, (long)this.clientPool.getNumActive());
        int count = this.monitor.getNumRenewedIdleConnections();
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException ex) {
            Assert.fail();
        }
        HClient client2 = this.clientPool.borrowClient();
        Assert.assertEquals((long)1L, (long)this.clientPool.getNumActive());
        Assert.assertEquals((long)(count + 1), (long)this.monitor.getNumRenewedIdleConnections());
        Assert.assertNotSame((Object)client1, (Object)client2);
    }
}

