/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.connection.ConnectionManagerEmptyListener;
import me.prettyprint.cassandra.connection.ConnectionManagerListener;
import me.prettyprint.cassandra.connection.HConnectionManager;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import org.junit.Assert;
import org.junit.Test;

public class HConnectionManagerListenerTest
extends BaseEmbededServerSetupTest {
    private String listenerName = "test-listener";

    @Test
    public void testOnRemoveHost() {
        this.setupClient();
        final boolean[] eventFired = new boolean[]{false};
        final CassandraHost host = new CassandraHost("127.0.0.1", 9170);
        this.connectionManager.addListener(this.listenerName, (ConnectionManagerListener)new ConnectionManagerEmptyListener(){

            public void onRemoveHost(CassandraHost cassandraHost, boolean removed, String message) {
                Assert.assertEquals((Object)cassandraHost, (Object)host);
                Assert.assertTrue((boolean)removed);
                eventFired[0] = true;
            }
        });
        this.connectionManager.removeCassandraHost(host);
        Assert.assertTrue((boolean)eventFired[0]);
    }

    @Test
    public void testOnAddCassandraHostFail() {
        this.setupClient();
        final CassandraHost host = new CassandraHost("127.0.0.1", 9180);
        final boolean[] eventFired = new boolean[]{false};
        this.connectionManager.addListener(this.listenerName, (ConnectionManagerListener)new ConnectionManagerEmptyListener(){

            public void onAddHost(CassandraHost cassandraHost, boolean added, String errorMessage, Exception e) {
                Assert.assertEquals((Object)cassandraHost, (Object)host);
                Assert.assertFalse((boolean)added);
                eventFired[0] = true;
            }
        });
        Assert.assertFalse((boolean)this.connectionManager.addCassandraHost(host));
        Assert.assertTrue((boolean)eventFired[0]);
    }

    @Test
    public void testOnAddCassandraHostFailExists() {
        this.setupClient();
        final CassandraHost host = new CassandraHost("127.0.0.1", 9170);
        final boolean[] eventFired = new boolean[]{false};
        this.connectionManager.addListener(this.listenerName, (ConnectionManagerListener)new ConnectionManagerEmptyListener(){

            public void onAddHost(CassandraHost cassandraHost, boolean added, String errorMessage, Exception e) {
                Assert.assertEquals((Object)cassandraHost, (Object)host);
                Assert.assertFalse((boolean)added);
                eventFired[0] = true;
            }
        });
        Assert.assertFalse((boolean)this.connectionManager.addCassandraHost(host));
        Assert.assertTrue((boolean)eventFired[0]);
    }

    @Test
    public void testOnAddCassandraHostSuccess() {
        this.setupClient();
        final CassandraHost host = new CassandraHost("127.0.0.1", 9170);
        final boolean[] eventFired = new boolean[]{false};
        this.connectionManager.addListener(this.listenerName, (ConnectionManagerListener)new ConnectionManagerEmptyListener(){

            public void onAddHost(CassandraHost cassandraHost, boolean added, String errorMessage, Exception e) {
                Assert.assertEquals((Object)cassandraHost, (Object)host);
                Assert.assertTrue((boolean)added);
                eventFired[0] = true;
            }
        });
        this.connectionManager.removeCassandraHost(host);
        Assert.assertTrue((boolean)this.connectionManager.addCassandraHost(host));
        Assert.assertTrue((boolean)eventFired[0]);
    }

    @Test
    public void testOnHostDown() {
        this.setupClient();
        final CassandraHost host = new CassandraHost("127.0.0.1", 9170);
        final boolean[] eventFired = new boolean[]{false};
        this.connectionManager.addListener(this.listenerName, (ConnectionManagerListener)new ConnectionManagerEmptyListener(){

            public void onHostDown(CassandraHost cassandraHost) {
                Assert.assertEquals((Object)cassandraHost, (Object)host);
                eventFired[0] = true;
            }
        });
        this.connectionManager.markHostAsDown(host);
        Assert.assertTrue((boolean)eventFired[0]);
    }

    @Test
    public void testOnHostRestored() throws InterruptedException {
        this.cassandraHostConfigurator = new CassandraHostConfigurator("127.0.0.1:9170");
        this.cassandraHostConfigurator.setRetryDownedHostsDelayInSeconds(1);
        this.cassandraHostConfigurator.setRetryDownedHosts(true);
        this.connectionManager = new HConnectionManager(this.clusterName, this.cassandraHostConfigurator);
        final CassandraHost host = new CassandraHost("127.0.0.1", 9170);
        final boolean[] eventFired = new boolean[]{false};
        this.connectionManager.addListener(this.listenerName, (ConnectionManagerListener)new ConnectionManagerEmptyListener(){

            public void onHostRestored(CassandraHost cassandraHost) {
                Assert.assertEquals((Object)cassandraHost, (Object)host);
                eventFired[0] = true;
            }
        });
        this.connectionManager.markHostAsDown(host);
        Thread.sleep(1100L);
        Assert.assertTrue((boolean)eventFired[0]);
    }

    @Test
    public void testOnSuspendCassandraHost() {
        this.setupClient();
        final CassandraHost host = new CassandraHost("127.0.0.1", 9170);
        Assert.assertTrue((boolean)this.connectionManager.suspendCassandraHost(host));
        final boolean[] eventFired = new boolean[]{false};
        this.connectionManager.addListener(this.listenerName, (ConnectionManagerListener)new ConnectionManagerEmptyListener(){

            public void onSuspendHost(CassandraHost cassandraHost, boolean removed) {
                Assert.assertEquals((Object)cassandraHost, (Object)host);
                Assert.assertTrue((boolean)removed);
                eventFired[0] = true;
            }
        });
    }

    @Test
    public void testOnUnSuspendCassandraHost() {
        this.setupClient();
        final CassandraHost host = new CassandraHost("127.0.0.1", 9170);
        Assert.assertTrue((boolean)this.connectionManager.suspendCassandraHost(host));
        final boolean[] eventFired = new boolean[]{false};
        this.connectionManager.addListener(this.listenerName, (ConnectionManagerListener)new ConnectionManagerEmptyListener(){

            public void onUnSuspendHost(CassandraHost cassandraHost, boolean readded) {
                Assert.assertEquals((Object)cassandraHost, (Object)host);
                Assert.assertTrue((boolean)readded);
                eventFired[0] = true;
            }
        });
        Assert.assertTrue((boolean)this.connectionManager.unsuspendCassandraHost(host));
    }
}

