/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.connection.HOpTimer;
import me.prettyprint.cassandra.connection.MetricsOpTimer;
import me.prettyprint.cassandra.service.Operation;
import me.prettyprint.cassandra.service.OperationType;
import me.prettyprint.hector.api.exceptions.HectorException;
import org.apache.cassandra.thrift.Cassandra;
import org.junit.Assert;
import org.junit.Test;

public class HConnectionManagerMetricsOpTimerTest
extends BaseEmbededServerSetupTest {
    @Test
    public void testWithOptimer() {
        this.setupClient();
        MetricsRegistry registry = new MetricsRegistry();
        MetricsOpTimer opTimer = new MetricsOpTimer(registry, "TEST_CLUSTER", TimeUnit.NANOSECONDS, TimeUnit.SECONDS);
        this.connectionManager.setTimer((HOpTimer)opTimer);
        this.connectionManager.operateWithFailover((Operation)new NullOp());
        SortedMap metrics = registry.groupedMetrics();
        Assert.assertNotNull((String)"Hector metric should exist in metrics registry", (Object)metrics);
        Assert.assertFalse((String)"Hector metrics should exist in metrics register", (boolean)metrics.isEmpty());
        Map.Entry entry = metrics.entrySet().iterator().next();
        Assert.assertEquals((String)"Incorrect metrics key should be [cluster_name].hector", (Object)"TEST_CLUSTER.hector", entry.getKey());
        Map.Entry metric = ((SortedMap)entry.getValue()).entrySet().iterator().next();
        Assert.assertEquals((String)"Incorrect metrics name should be META_READ", (Object)"META_READ", (Object)((MetricName)metric.getKey()).getName());
        Assert.assertEquals((String)"Incorrect metrics type should be timer", Timer.class, ((Metric)metric.getValue()).getClass());
    }

    class NullOp
    extends Operation<String> {
        NullOp() {
            super(OperationType.META_READ);
        }

        public String execute(Cassandra.Client cassandra) throws HectorException {
            return null;
        }
    }
}

