/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.connection.HConnectionManager;
import me.prettyprint.cassandra.connection.client.HClient;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.FailoverPolicy;
import me.prettyprint.cassandra.service.Operation;
import me.prettyprint.cassandra.service.OperationType;
import me.prettyprint.hector.api.exceptions.HTimedOutException;
import me.prettyprint.hector.api.exceptions.HectorException;
import org.apache.cassandra.thrift.Cassandra;
import org.junit.Assert;
import org.junit.Test;

public class HConnectionManagerTest
extends BaseEmbededServerSetupTest {
    @Test
    public void testRemoveHost() {
        this.setupClient();
        CassandraHost cassandraHost = new CassandraHost("127.0.0.1", 9170);
        this.connectionManager.removeCassandraHost(cassandraHost);
        Assert.assertEquals((long)0L, (long)this.connectionManager.getActivePools().size());
        Assert.assertTrue((boolean)this.connectionManager.addCassandraHost(cassandraHost));
        Assert.assertEquals((long)1L, (long)this.connectionManager.getActivePools().size());
        this.connectionManager.markHostAsDown(cassandraHost);
        Assert.assertTrue((boolean)this.connectionManager.removeCassandraHost(cassandraHost));
    }

    @Test
    public void testAddCassandraHostFail() {
        this.setupClient();
        CassandraHost cassandraHost = new CassandraHost("127.0.0.1", 9180);
        Assert.assertFalse((boolean)this.connectionManager.addCassandraHost(cassandraHost));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullHostList() {
        new HConnectionManager(this.clusterName, new CassandraHostConfigurator());
    }

    @Test
    public void testMarkHostDownWithNoRetry() {
        this.cassandraHostConfigurator = new CassandraHostConfigurator("127.0.0.1:9170");
        this.cassandraHostConfigurator.setRetryDownedHosts(false);
        this.connectionManager = new HConnectionManager(this.clusterName, this.cassandraHostConfigurator);
        new CassandraHost("127.0.0.1", 9170);
        HClient client = this.connectionManager.borrowClient();
        this.connectionManager.markHostAsDown(client.getCassandraHost());
        Assert.assertEquals((long)0L, (long)this.connectionManager.getActivePools().size());
    }

    @Test
    public void testSuspendCassandraHost() {
        this.setupClient();
        CassandraHost cassandraHost = new CassandraHost("127.0.0.1", 9170);
        Assert.assertTrue((boolean)this.connectionManager.suspendCassandraHost(cassandraHost));
        Assert.assertEquals((long)1L, (long)this.connectionManager.getSuspendedCassandraHosts().size());
        Assert.assertTrue((boolean)this.connectionManager.unsuspendCassandraHost(cassandraHost));
    }

    @Test(expected=HTimedOutException.class)
    public void testTimedOutOperateWithFailover() {
        this.setupClient();
        FailoverPolicy fp = FailoverPolicy.ON_FAIL_TRY_ONE_NEXT_AVAILABLE;
        this.connectionManager.operateWithFailover((Operation)new TimeoutOp(fp));
    }

    class TimeoutOp
    extends StubOp {
        TimeoutOp(FailoverPolicy fp) {
            super(fp);
        }

        public String execute(Cassandra.Client cassandra) throws HectorException {
            throw new HTimedOutException("fake timeout");
        }
    }

    abstract class StubOp
    extends Operation<String> {
        StubOp(FailoverPolicy fp) {
            this(OperationType.META_READ);
            this.failoverPolicy = fp;
        }

        public StubOp(OperationType operationType) {
            super(operationType);
        }
    }
}

