/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.connection.client.HThriftClient;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.exceptions.HInvalidRequestException;
import me.prettyprint.hector.api.factory.HFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HThriftClientTest
extends BaseEmbededServerSetupTest {
    private HThriftClient hThriftClient;
    private CassandraHost cassandraHost;

    @Before
    public void doSetup() {
        this.cassandraHost = new CassandraHost("127.0.0.1:9170");
        this.hThriftClient = new HThriftClient(this.cassandraHost);
    }

    @After
    public void doTeardown() {
        this.hThriftClient.close();
    }

    @Test
    public void testOpenAndClose() {
        Assert.assertTrue((boolean)this.hThriftClient.open().isOpen());
        Assert.assertFalse((boolean)this.hThriftClient.close().isOpen());
    }

    @Test(expected=IllegalStateException.class)
    public void testFailOnDoubleOpen() {
        this.hThriftClient.open().open();
    }

    @Test(expected=IllegalStateException.class)
    public void testGetCassandraNotOpen() {
        this.hThriftClient.getCassandra();
    }

    @Test
    public void testGetCassandraWithKeyspace() {
        this.hThriftClient.open();
        this.hThriftClient.getCassandra("Keyspace1");
        Assert.assertTrue((boolean)this.hThriftClient.isOpen());
    }

    @Test
    public void testGetCassandraWithNullKeyspace() {
        this.hThriftClient.open();
        this.hThriftClient.getCassandra("Keyspace1");
        this.hThriftClient.getCassandra(null);
        Assert.assertTrue((boolean)this.hThriftClient.isOpen());
    }

    @Test
    public void testNonExistingKeyspace() {
        this.hThriftClient.open();
        String ksname = "test_ks_" + Thread.currentThread().getName() + Thread.currentThread().getId();
        Exception caughtException = null;
        try {
            this.hThriftClient.getCassandra(ksname);
        }
        catch (Exception e) {
            caughtException = e;
        }
        Assert.assertTrue((String)"if you try to access a non-existent ks, hclient should throw exception", (caughtException != null && caughtException instanceof HInvalidRequestException ? 1 : 0) != 0);
        KeyspaceDefinition ksdef = HFactory.createKeyspaceDefinition((String)ksname);
        Cluster cluster = HFactory.getOrCreateCluster((String)this.clusterName, (String)"127.0.0.1:9170");
        cluster.addKeyspace(ksdef);
        this.hThriftClient.getCassandra(ksname);
        Assert.assertTrue((boolean)this.hThriftClient.isOpen());
    }

    @Test
    public void testNonExistingKeyspaceWithHostAutoDiscover() {
        this.hThriftClient.open();
        String ksname = "test_ks_2_" + Thread.currentThread().getName() + Thread.currentThread().getId();
        Exception caughtException = null;
        try {
            this.hThriftClient.getCassandra(ksname);
        }
        catch (Exception e) {
            caughtException = e;
        }
        Assert.assertTrue((String)"if you try to access a non-existent ks, hclient should throw exception", (caughtException != null && caughtException instanceof HInvalidRequestException ? 1 : 0) != 0);
        KeyspaceDefinition ksdef = HFactory.createKeyspaceDefinition((String)ksname);
        CassandraHostConfigurator cassandraHostConfigurator = new CassandraHostConfigurator("127.0.0.1");
        cassandraHostConfigurator.setPort(9170);
        cassandraHostConfigurator.setRunAutoDiscoveryAtStartup(true);
        cassandraHostConfigurator.setAutoDiscoverHosts(true);
        Cluster cluster = HFactory.getOrCreateCluster((String)this.clusterName, (CassandraHostConfigurator)cassandraHostConfigurator);
        cluster.addKeyspace(ksdef);
        this.hThriftClient.getCassandra(ksname);
        Assert.assertTrue((boolean)this.hThriftClient.isOpen());
    }
}

