/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import me.prettyprint.cassandra.connection.HConnectionManager;
import me.prettyprint.cassandra.connection.HostTimeoutTracker;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HostTimeoutTrackerTest {
    private HostTimeoutTracker hostTimeoutTracker;

    @Before
    public void setup() {
        CassandraHostConfigurator cassandraHostConfigurator = new CassandraHostConfigurator("localhost:9170");
        cassandraHostConfigurator.setHostTimeoutCounter(3);
        HConnectionManager connectionManager = new HConnectionManager("TestCluster", cassandraHostConfigurator);
        this.hostTimeoutTracker = new HostTimeoutTracker(connectionManager, cassandraHostConfigurator);
    }

    @Test
    public void testTrackHostLatency() {
        CassandraHost cassandraHost = new CassandraHost("localhost:9170");
        Assert.assertFalse((boolean)this.hostTimeoutTracker.checkTimeout(cassandraHost));
        Assert.assertFalse((boolean)this.hostTimeoutTracker.checkTimeout(cassandraHost));
        Assert.assertFalse((boolean)this.hostTimeoutTracker.checkTimeout(cassandraHost));
        try {
            Thread.currentThread();
            Thread.sleep(501L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.hostTimeoutTracker.checkTimeout(cassandraHost));
    }
}

