/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.connection.LatencyAwareHClientPool;
import me.prettyprint.cassandra.connection.factory.HClientFactory;
import me.prettyprint.cassandra.connection.factory.HThriftClientFactoryImpl;
import me.prettyprint.cassandra.service.CassandraClientMonitor;
import me.prettyprint.cassandra.service.CassandraHost;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LatencyAwareHClientPoolTest
extends BaseEmbededServerSetupTest {
    private static final double DYNAMIC_BADNESS_THRESHOLD = 0.24;
    private CassandraHost cassandraHost;
    private LatencyAwareHClientPool clientPool;

    @Before
    public void setupTest() {
        this.setupClient();
        this.cassandraHost = this.cassandraHostConfigurator.buildCassandraHosts()[0];
        HThriftClientFactoryImpl factory = new HThriftClientFactoryImpl();
        this.clientPool = new LatencyAwareHClientPool((HClientFactory)factory, this.cassandraHost, new CassandraClientMonitor(this.connectionManager));
    }

    @Test
    public void testScore() {
        this.clientPool.add(120.0);
        this.clientPool.add(121.0);
        this.clientPool.add(122.0);
        this.clientPool.add(123.0);
        this.clientPool.add(124.0);
        double score1 = this.clientPool.score();
        this.clientPool.clear();
        this.clientPool.add(150.0);
        this.clientPool.add(151.0);
        this.clientPool.add(152.0);
        this.clientPool.add(152.0);
        this.clientPool.add(1530.0);
        double score2 = this.clientPool.score();
        this.clientPool.clear();
        System.out.println((score2 - score1) / score2);
        Assert.assertTrue((String)"Error... score 2 is bigger than score 1...", ((score2 - score1) / score2 > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testReverse() {
        this.clientPool.add(100.0);
        this.clientPool.add(101.0);
        this.clientPool.add(102.0);
        this.clientPool.add(103.0);
        this.clientPool.add(104.0);
        double score3 = this.clientPool.score();
        this.clientPool.clear();
        this.clientPool.add(10000.0);
        this.clientPool.add(10000.0);
        this.clientPool.add(10020.0);
        this.clientPool.add(11030.0);
        this.clientPool.add(1604.0);
        double score4 = this.clientPool.score();
        this.clientPool.clear();
        Assert.assertTrue((String)"Error the latencies are not taken into account!", ((score3 - score4) / score3 < 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testThreshhold() {
        for (int i = 50; i < 150; ++i) {
            this.clientPool.add((double)i);
        }
        double score1 = this.clientPool.score();
        this.clientPool.clear();
        System.out.println(score1);
        for (int i = 450; i < 550; ++i) {
            this.clientPool.add((double)i);
        }
        double score2 = this.clientPool.score();
        this.clientPool.clear();
        System.out.println(score2);
        System.out.println((score2 - score1) / score2);
        Assert.assertTrue((String)"Error The Badness threshold value is not taken into account!", ((score2 - score1) / score2 > 0.24 ? 1 : 0) != 0);
    }
}

