/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import me.prettyprint.cassandra.connection.BaseBalancingPolicyTest;
import me.prettyprint.cassandra.connection.ConcurrentHClientPool;
import me.prettyprint.cassandra.connection.HClientPool;
import me.prettyprint.cassandra.connection.LeastActiveBalancingPolicy;
import me.prettyprint.cassandra.service.CassandraHost;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class LeastActiveBalancingPolicyTest
extends BaseBalancingPolicyTest {
    private LeastActiveBalancingPolicy leastActiveBalancingPolicy;

    @Test
    public void testGetPoolOk() {
        this.leastActiveBalancingPolicy = new LeastActiveBalancingPolicy();
        Assert.assertEquals((Object)this.poolWith5Active, (Object)this.leastActiveBalancingPolicy.getPool((Collection)this.pools, null));
        Assert.assertEquals((Object)this.poolWith5Active, (Object)this.leastActiveBalancingPolicy.getPool((Collection)this.pools, null));
        Assert.assertEquals((Object)this.poolWith5Active, (Object)this.leastActiveBalancingPolicy.getPool((Collection)this.pools, null));
        Mockito.when((Object)this.poolWith5Active.getNumActive()).thenReturn((Object)8);
        Assert.assertEquals((Object)this.poolWith7Active, (Object)this.leastActiveBalancingPolicy.getPool((Collection)this.pools, null));
        Assert.assertEquals((Object)this.poolWith7Active, (Object)this.leastActiveBalancingPolicy.getPool((Collection)this.pools, null));
        Assert.assertEquals((Object)this.poolWith7Active, (Object)this.leastActiveBalancingPolicy.getPool((Collection)this.pools, null));
        Mockito.when((Object)this.poolWith5Active.getNumActive()).thenReturn((Object)4);
        Assert.assertEquals((Object)this.poolWith5Active, (Object)this.leastActiveBalancingPolicy.getPool((Collection)this.pools, null));
        Assert.assertEquals((Object)this.poolWith5Active, (Object)this.leastActiveBalancingPolicy.getPool((Collection)this.pools, null));
        Assert.assertEquals((Object)this.poolWith5Active, (Object)this.leastActiveBalancingPolicy.getPool((Collection)this.pools, null));
    }

    @Test
    public void testSkipExhausted() {
        this.leastActiveBalancingPolicy = new LeastActiveBalancingPolicy();
        Assert.assertEquals((Object)this.poolWith7Active, (Object)this.leastActiveBalancingPolicy.getPool((Collection)this.pools, new HashSet<CassandraHost>(Arrays.asList(new CassandraHost("127.0.0.1:9160")))));
        Assert.assertEquals((Object)this.poolWith5Active, (Object)this.leastActiveBalancingPolicy.getPool((Collection)this.pools, new HashSet<CassandraHost>(Arrays.asList(new CassandraHost("127.0.0.2:9161")))));
    }

    @Test
    public void testShuffleOnAllEqual() {
        ConcurrentHClientPool poolWith5Active2 = (ConcurrentHClientPool)Mockito.mock(ConcurrentHClientPool.class);
        Mockito.when((Object)poolWith5Active2.getNumActive()).thenReturn((Object)5);
        Mockito.when((Object)poolWith5Active2.getCassandraHost()).thenReturn((Object)new CassandraHost("127.0.0.4:9163"));
        ConcurrentHClientPool poolWith5Active3 = (ConcurrentHClientPool)Mockito.mock(ConcurrentHClientPool.class);
        Mockito.when((Object)poolWith5Active3.getNumActive()).thenReturn((Object)5);
        Mockito.when((Object)poolWith5Active3.getCassandraHost()).thenReturn((Object)new CassandraHost("127.0.0.5:9164"));
        this.pools.add(poolWith5Active2);
        this.pools.add(poolWith5Active3);
        this.leastActiveBalancingPolicy = new LeastActiveBalancingPolicy();
        HashSet<CassandraHost> foundHosts = new HashSet<CassandraHost>(3);
        for (int i = 0; i < 50; ++i) {
            HClientPool foundPool = this.leastActiveBalancingPolicy.getPool((Collection)this.pools, null);
            foundHosts.add(foundPool.getCassandraHost());
            assert (5 == foundPool.getNumActive());
        }
        Assert.assertEquals((long)3L, (long)foundHosts.size());
    }
}

