/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import com.google.common.collect.Sets;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import me.prettyprint.cassandra.connection.HConnectionManager;
import me.prettyprint.cassandra.connection.NodeDiscovery;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.ThriftCluster;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import org.apache.cassandra.thrift.EndpointDetails;
import org.apache.cassandra.thrift.TokenRange;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class NodeDiscoveryTest {
    CassandraHostConfigurator cassandraHostConfigurator;
    HConnectionManager connectionManager;
    ThriftCluster cluster;

    @Before
    public void setup() {
        this.cassandraHostConfigurator = new CassandraHostConfigurator("localhost");
        this.connectionManager = (HConnectionManager)Mockito.mock(HConnectionManager.class);
        this.cluster = (ThriftCluster)Mockito.mock(ThriftCluster.class);
        Mockito.when((Object)this.cluster.getConfigurator()).thenReturn((Object)this.cassandraHostConfigurator);
        final KeyspaceDefinition kdef = (KeyspaceDefinition)Mockito.mock(KeyspaceDefinition.class);
        Mockito.when((Object)kdef.getName()).thenReturn((Object)"TestKeyspace");
        Mockito.when((Object)this.cluster.describeKeyspaces()).thenReturn((Object)new LinkedList<KeyspaceDefinition>(){
            {
                this.add(kdef);
            }
        });
    }

    @Test
    public void testDoAdd() {
        List<TokenRange> tokens = NodeDiscoveryTest.createRange("localhost", "google.com");
        Mockito.when((Object)this.cluster.describeRing("TestKeyspace")).thenReturn(tokens);
        Mockito.when((Object)this.connectionManager.getHosts()).thenReturn((Object)Sets.newHashSet((Object[])new CassandraHost[]{new CassandraHost("localhost", 9160)}));
        NodeDiscovery q = new NodeDiscovery(this.cluster, this.cassandraHostConfigurator, this.connectionManager);
        q.doAddNodes();
        ((HConnectionManager)Mockito.verify((Object)this.connectionManager)).addCassandraHost(new CassandraHost("google.com", 9160));
    }

    @Test
    public void testMultipleAdded() {
        List<TokenRange> tokens = NodeDiscoveryTest.createRange("localhost", "google.com", "yahoo.com", "datastax.com");
        Mockito.when((Object)this.cluster.describeRing("TestKeyspace")).thenReturn(tokens);
        Mockito.when((Object)this.connectionManager.getHosts()).thenReturn((Object)Sets.newHashSet((Object[])new CassandraHost[]{new CassandraHost("localhost", 9160)}));
        NodeDiscovery q = new NodeDiscovery(this.cluster, this.cassandraHostConfigurator, this.connectionManager);
        q.doAddNodes();
        ((HConnectionManager)Mockito.verify((Object)this.connectionManager)).addCassandraHost(new CassandraHost("google.com", 9160));
        ((HConnectionManager)Mockito.verify((Object)this.connectionManager)).addCassandraHost(new CassandraHost("yahoo.com", 9160));
        ((HConnectionManager)Mockito.verify((Object)this.connectionManager)).addCassandraHost(new CassandraHost("datastax.com", 9160));
    }

    @Test
    public void testNoneAdded() {
        List<TokenRange> tokens = NodeDiscoveryTest.createRange("localhost");
        Mockito.when((Object)this.cluster.describeRing("TestKeyspace")).thenReturn(tokens);
        Mockito.when((Object)this.connectionManager.getHosts()).thenReturn((Object)Sets.newHashSet((Object[])new CassandraHost[]{new CassandraHost("localhost", 9160)}));
        NodeDiscovery q = new NodeDiscovery(this.cluster, this.cassandraHostConfigurator, this.connectionManager);
        Assert.assertEquals((int)0, (int)q.discoverNodes().size());
    }

    private static List<TokenRange> createRange(String ... hosts) {
        LinkedList<TokenRange> ret = new LinkedList<TokenRange>();
        for (final String h : hosts) {
            TokenRange tr1 = (TokenRange)Mockito.mock(TokenRange.class);
            Mockito.when((Object)tr1.getEndpoint_details()).thenReturn((Object)new LinkedList<EndpointDetails>(){
                {
                    this.add(new EndpointDetails(h, "DC1"));
                }
            });
            ret.add(tr1);
        }
        return ret;
    }
}

