/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import me.prettyprint.cassandra.connection.BaseBalancingPolicyTest;
import me.prettyprint.cassandra.connection.RoundRobinBalancingPolicy;
import me.prettyprint.cassandra.service.CassandraHost;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class RoundRobinBalancingPolicyTest
extends BaseBalancingPolicyTest {
    private RoundRobinBalancingPolicy roundRobinBalancingPolicy;

    @Test
    public void testGetPoolOk() {
        this.roundRobinBalancingPolicy = new RoundRobinBalancingPolicy();
        Assert.assertEquals((long)this.poolWith5Active.getNumActive(), (long)this.roundRobinBalancingPolicy.getPool((Collection)this.pools, null).getNumActive());
        Assert.assertEquals((long)this.poolWith7Active.getNumActive(), (long)this.roundRobinBalancingPolicy.getPool((Collection)this.pools, null).getNumActive());
        Assert.assertEquals((long)this.poolWith10Active.getNumActive(), (long)this.roundRobinBalancingPolicy.getPool((Collection)this.pools, null).getNumActive());
        Assert.assertEquals((long)this.poolWith5Active.getNumActive(), (long)this.roundRobinBalancingPolicy.getPool((Collection)this.pools, null).getNumActive());
        Assert.assertEquals((long)this.poolWith7Active.getNumActive(), (long)this.roundRobinBalancingPolicy.getPool((Collection)this.pools, null).getNumActive());
        Assert.assertEquals((long)this.poolWith10Active.getNumActive(), (long)this.roundRobinBalancingPolicy.getPool((Collection)this.pools, null).getNumActive());
        Assert.assertEquals((long)this.poolWith5Active.getNumActive(), (long)this.roundRobinBalancingPolicy.getPool((Collection)this.pools, null).getNumActive());
        Assert.assertEquals((long)this.poolWith7Active.getNumActive(), (long)this.roundRobinBalancingPolicy.getPool((Collection)this.pools, null).getNumActive());
        Assert.assertEquals((long)this.poolWith10Active.getNumActive(), (long)this.roundRobinBalancingPolicy.getPool((Collection)this.pools, null).getNumActive());
        for (int x = 0; x < 65536; ++x) {
            assert (this.roundRobinBalancingPolicy.getPool((Collection)this.pools, null).getNumActive() >= 5);
        }
    }

    @Test
    public void testIgnoreExhausted() {
        Mockito.when((Object)this.poolWith5Active.getCassandraHost()).thenReturn((Object)new CassandraHost("127.0.0.1:9160"));
        Mockito.when((Object)this.poolWith7Active.getCassandraHost()).thenReturn((Object)new CassandraHost("127.0.0.2:9161"));
        Mockito.when((Object)this.poolWith10Active.getCassandraHost()).thenReturn((Object)new CassandraHost("127.0.0.3:9162"));
        this.roundRobinBalancingPolicy = new RoundRobinBalancingPolicy();
        Assert.assertEquals((Object)this.poolWith7Active, (Object)this.roundRobinBalancingPolicy.getPool((Collection)this.pools, new HashSet<CassandraHost>(Arrays.asList(new CassandraHost("127.0.0.1:9160")))));
        Assert.assertEquals((Object)this.poolWith10Active, (Object)this.roundRobinBalancingPolicy.getPool((Collection)this.pools, new HashSet<CassandraHost>(Arrays.asList(new CassandraHost("127.0.0.1:9160")))));
        Assert.assertEquals((Object)this.poolWith7Active, (Object)this.roundRobinBalancingPolicy.getPool((Collection)this.pools, new HashSet<CassandraHost>(Arrays.asList(new CassandraHost("127.0.0.1:9160")))));
        Assert.assertEquals((Object)this.poolWith10Active, (Object)this.roundRobinBalancingPolicy.getPool((Collection)this.pools, new HashSet<CassandraHost>(Arrays.asList(new CassandraHost("127.0.0.1:9160")))));
    }

    @Test
    public void testIgnoreExhaustedAll() {
        Mockito.when((Object)this.poolWith5Active.getCassandraHost()).thenReturn((Object)new CassandraHost("127.0.0.1:9160"));
        Mockito.when((Object)this.poolWith7Active.getCassandraHost()).thenReturn((Object)new CassandraHost("127.0.0.2:9161"));
        Mockito.when((Object)this.poolWith10Active.getCassandraHost()).thenReturn((Object)new CassandraHost("127.0.0.3:9162"));
        this.roundRobinBalancingPolicy = new RoundRobinBalancingPolicy();
        Assert.assertNotNull((Object)this.roundRobinBalancingPolicy.getPool((Collection)this.pools, new HashSet<CassandraHost>(Arrays.asList(new CassandraHost("127.0.0.1:9160"), new CassandraHost("127.0.0.2:9161"), new CassandraHost("127.0.0.3:9162")))));
    }
}

