/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.examples;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.prettyprint.cassandra.examples.ExampleDaoV2;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.testutils.EmbeddedServerHelper;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.thrift.transport.TTransportException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExampleDaoV2Test {
    private static EmbeddedServerHelper embedded;

    @BeforeClass
    public static void setup() throws TTransportException, IOException, InterruptedException, ConfigurationException {
        embedded = new EmbeddedServerHelper();
        embedded.setup();
    }

    @AfterClass
    public static void teardown() throws IOException {
        EmbeddedServerHelper.teardown();
    }

    @Test
    public void testInsertGetDelete() throws HectorException {
        Cluster c = HFactory.getOrCreateCluster((String)"MyCluster", (String)"localhost:9170");
        ExampleDaoV2 dao = new ExampleDaoV2(HFactory.createKeyspace((String)"Keyspace1", (Cluster)c));
        Assert.assertNull((Object)dao.get((Object)"key", (Serializer)StringSerializer.get()));
        dao.insert((Object)"key", "value", (Serializer)StringSerializer.get());
        Assert.assertEquals((Object)"value", (Object)dao.get((Object)"key", (Serializer)StringSerializer.get()));
        dao.delete((Serializer)StringSerializer.get(), (Object[])new String[]{"key"});
        Assert.assertNull((Object)dao.get((Object)"key", (Serializer)StringSerializer.get()));
    }

    @Test
    public void testMultiInsertGetDelete() throws HectorException {
        Cluster c = HFactory.getOrCreateCluster((String)"MyCluster", (String)"localhost:9170");
        ExampleDaoV2 dao = new ExampleDaoV2(HFactory.createKeyspace((String)"Keyspace1", (Cluster)c));
        Map ret = dao.getMulti((Serializer)StringSerializer.get(), (Object[])new String[]{"key1", "key2"});
        Assert.assertNotNull((Object)ret);
        Assert.assertNull((String)"value1", ret.get("key1"));
        HashMap<String, String> keyValues = new HashMap<String, String>();
        keyValues.put("key1", "value1");
        keyValues.put("key2", "value2");
        dao.insertMulti(keyValues, (Serializer)StringSerializer.get());
        ret = dao.getMulti((Serializer)StringSerializer.get(), (Object[])new String[]{"key1", "key2"});
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((Object)"value1", ret.get("key1"));
        Assert.assertEquals((Object)"value2", ret.get("key2"));
        ret = dao.getMulti((Serializer)StringSerializer.get(), (Object[])new String[]{"key2", "key3"});
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((Object)"value2", ret.get("key2"));
        Assert.assertNull(ret.get("key3"));
        Assert.assertNull(ret.get("key1"));
        dao.delete((Serializer)StringSerializer.get(), (Object[])new String[]{"key1", "key2"});
        ret = dao.getMulti((Serializer)StringSerializer.get(), (Object[])new String[]{"key1", "key2"});
        Assert.assertNotNull((Object)ret);
        Assert.assertNull(ret.get("key1"));
        Assert.assertNull(ret.get("key2"));
    }
}

