/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.io.ChunkInputStream;
import me.prettyprint.cassandra.io.ChunkOutputStream;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.cassandra.service.ThriftCluster;
import me.prettyprint.cassandra.service.ThriftKsDef;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.KsDef;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StreamTest
extends BaseEmbededServerSetupTest {
    private static final String STRING_TEST_DATA = "This is a testdata, we should be able to read it again via the Inpustream - \u00e9\u00e8\u00eb\u00e0\u00e2";
    private static final byte[] BINARY_TEST_DATA = new byte[]{1, 0, 10, 3, 13, 10, 4, -1, 5};
    public static final String POOL_NAME = "TestPool";
    public static final String KEYSPACE = "TestKeyspace";
    public static final String BLOB_CF = "Blob";
    public static final CfDef BLOB_CF_DEF = new CfDef("TestKeyspace", "Blob");
    public static KeyspaceDefinition KEYSPACE_DEV;
    private Keyspace keyspace;
    private ThriftCluster cassandraCluster;
    private CassandraHostConfigurator cassandraHostConfigurator;

    @Before
    public void setUp() throws Exception {
        super.setupClient();
        KEYSPACE_DEV = new ThriftKsDef(new KsDef(KEYSPACE, "org.apache.cassandra.locator.SimpleStrategy", Arrays.asList(BLOB_CF_DEF)));
        ((ThriftKsDef)KEYSPACE_DEV).setReplicationFactor(1);
        this.cassandraHostConfigurator = new CassandraHostConfigurator("localhost:9170");
        this.cassandraCluster = new ThriftCluster("Test Cluster", this.cassandraHostConfigurator);
        this.keyspace = HFactory.createKeyspace((String)KEYSPACE, (Cluster)this.cassandraCluster);
        try {
            this.cassandraCluster.dropKeyspace(KEYSPACE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cassandraCluster.addKeyspace(KEYSPACE_DEV);
    }

    @Test
    public void testStreaming() throws IOException {
        String key1 = UUID.randomUUID().toString();
        String key2 = UUID.randomUUID().toString();
        this.check(key1, 10);
        this.check(key2, 10);
        this.check(key2, 10000);
        this.check(key1, BINARY_TEST_DATA, 10);
    }

    private void check(String key, int chunksize) throws IOException {
        this.check(key, STRING_TEST_DATA.getBytes(), chunksize);
    }

    private void check(String key, byte[] value, int chunksize) throws IOException {
        ChunkOutputStream out = new ChunkOutputStream(this.keyspace, BLOB_CF, (Object)key, (Serializer)StringSerializer.get(), chunksize);
        out.write(value);
        out.close();
        ChunkInputStream in = new ChunkInputStream(this.keyspace, BLOB_CF, (Object)key, (Serializer)StringSerializer.get());
        int i = -1;
        int written = 0;
        while ((i = in.read()) != -1) {
            Assert.assertSame((Object)value[written++], (Object)((byte)i));
        }
        Assert.assertEquals((long)value.length, (long)written);
        in.close();
    }

    @Test
    public void testSkip() throws IOException {
        String key = UUID.randomUUID().toString();
        String testData = "This is a testdata, we should be able to read it again via the Inpustream";
        ChunkOutputStream out = new ChunkOutputStream(this.keyspace, BLOB_CF, (Object)key, (Serializer)StringSerializer.get(), 10);
        out.write(testData.getBytes());
        out.close();
        ChunkInputStream in = new ChunkInputStream(this.keyspace, BLOB_CF, (Object)key, (Serializer)StringSerializer.get());
        int skip = 5;
        in.skip((long)skip);
        int i = -1;
        int written = skip;
        while ((i = in.read()) != -1) {
            Assert.assertSame((Object)Character.valueOf(testData.charAt(written++)), (Object)Character.valueOf((char)i));
        }
        Assert.assertEquals((long)testData.length(), (long)written);
        in.close();
    }

    static {
        StreamTest.BLOB_CF_DEF.comparator_type = "IntegerType";
    }
}

