/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.locking;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.locking.HLockManagerImpl;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.ddl.ColumnFamilyDefinition;
import me.prettyprint.hector.api.ddl.KeyspaceDefinition;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.locking.HLock;
import me.prettyprint.hector.api.locking.HLockManager;
import me.prettyprint.hector.api.locking.HLockManagerConfigurator;
import me.prettyprint.hector.api.locking.HLockTimeoutException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HLockManagerImplTest
extends BaseEmbededServerSetupTest {
    private static final Logger logger = LoggerFactory.getLogger(HLockManagerImplTest.class);
    Cluster cluster;
    HLockManager lm;
    HLockManagerConfigurator hlc;

    @Before
    public void setupTest() {
        this.cluster = HFactory.getOrCreateCluster((String)"MyCluster", (CassandraHostConfigurator)this.getCHCForTest());
        this.hlc = new HLockManagerConfigurator();
        this.hlc.setReplicationFactor(1);
        this.lm = new HLockManagerImpl(this.cluster, this.hlc);
        this.lm.init();
    }

    @Test
    public void testInitWithDefaults() {
        KeyspaceDefinition keyspaceDef = this.cluster.describeKeyspace(this.lm.getKeyspace().getKeyspaceName());
        Assert.assertNotNull((Object)keyspaceDef);
        Assert.assertTrue((boolean)this.verifyCFCreation(keyspaceDef.getCfDefs()));
    }

    @Test
    public void testHeartbeatNoExpiration() throws InterruptedException {
        HLock lock = this.lm.createLock("/testHeartbeatNoExpiration");
        this.lm.acquire(lock);
        Assert.assertTrue((boolean)lock.isAcquired());
        Thread.sleep(this.hlc.getLocksTTLInMillis() + 2000L);
        HLock newLock = this.lm.createLock("/testHeartbeatNoExpiration");
        boolean lockTimedOut = false;
        try {
            this.lm.acquire(newLock, 0L);
        }
        catch (HLockTimeoutException te) {
            lockTimedOut = true;
        }
        Assert.assertTrue((boolean)lock.isAcquired());
        Assert.assertFalse((boolean)newLock.isAcquired());
        Assert.assertTrue((boolean)lockTimedOut);
        this.lm.release(lock);
    }

    @Test
    public void testHeartbeatFailure() throws InterruptedException {
        HLockManagerImpl failedLockManager = new HLockManagerImpl(this.cluster, this.hlc);
        failedLockManager.init();
        HLock lock = failedLockManager.createLock("/testHeartbeatFailure");
        failedLockManager.acquire(lock);
        Assert.assertTrue((boolean)lock.isAcquired());
        failedLockManager.shutdownScheduler();
        Thread.sleep(this.hlc.getLocksTTLInMillis() + 2000L);
        HLock newLock = this.lm.createLock("/testHeartbeatFailure");
        boolean lockTimedOut = false;
        try {
            this.lm.acquire(newLock, 0L);
        }
        catch (HLockTimeoutException te) {
            lockTimedOut = true;
        }
        Assert.assertFalse((boolean)lockTimedOut);
        Assert.assertTrue((boolean)newLock.isAcquired());
        this.lm.release(newLock);
    }

    @Test
    public void testNonConcurrentLockUnlock() {
        HLock lock = this.lm.createLock("/testNonConcurrentLockUnlock");
        this.lm.acquire(lock);
        Assert.assertTrue((boolean)lock.isAcquired());
        try {
            HLock lock2 = this.lm.createLock("/testNonConcurrentLockUnlock");
            this.lm.acquire(lock2, 1000L);
            Assert.fail();
        }
        catch (HLockTimeoutException e) {
            // empty catch block
        }
        this.lm.release(lock);
        Assert.assertFalse((boolean)lock.isAcquired());
        HLock nextLock = this.lm.createLock("/testNonConcurrentLockUnlock");
        this.lm.acquire(nextLock, 0L);
        Assert.assertTrue((boolean)nextLock.isAcquired());
        this.lm.release(nextLock);
    }

    @Test
    public void testNoConflict() throws InterruptedException {
        int i;
        Semaphore failSemaphore = new Semaphore(1);
        int lockManagers = 5;
        int lockClients = 30;
        LockWorkerPool[] pools = new LockWorkerPool[lockManagers];
        for (i = 0; i < lockManagers; ++i) {
            HLockManagerImpl lm = new HLockManagerImpl(this.cluster, this.hlc);
            lm.init();
            pools[i] = new LockWorkerPool(lockClients, "/testNoConflict", (HLockManager)lm, failSemaphore);
            pools[i].go();
        }
        for (i = 0; i < lockManagers; ++i) {
            pools[i].waitToFinish();
            Assert.assertFalse((boolean)pools[i].isFailed());
        }
    }

    private boolean verifyCFCreation(List<ColumnFamilyDefinition> cfDefs) {
        for (ColumnFamilyDefinition cfDef : cfDefs) {
            if (!cfDef.getName().equals("HLocks")) continue;
            return true;
        }
        return false;
    }

    private static class LockWorker
    implements Runnable {
        private LockWorkerPool pool;

        public LockWorker(LockWorkerPool pool) {
            this.pool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HLock lock = this.pool.lm.createLock(this.pool.path);
            try {
                try {
                    this.pool.startLatch.await();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                logger.info("{} trying", (Object)lock);
                this.pool.lm.acquire(lock);
                logger.info("{} acquired", (Object)lock);
                if (!this.pool.failSemaphore.tryAcquire()) {
                    logger.error("Acquired semaphore when we shouldn't.  Failing test");
                    this.pool.setFailed();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.pool.failSemaphore.release();
                logger.info("{} released", (Object)lock);
            }
            catch (Throwable t) {
                logger.error("Error when trying to acquire lock", t);
                this.pool.setFailed();
            }
            finally {
                this.pool.lm.release(lock);
                this.pool.finishLatch.countDown();
            }
        }
    }

    private static class LockWorkerPool {
        private final int numberLocks;
        private final String path;
        private final HLockManager lm;
        private final ExecutorService executor;
        private final CountDownLatch startLatch;
        private final CountDownLatch finishLatch;
        private final Semaphore failSemaphore;
        private boolean failed;

        private LockWorkerPool(int numberLocks, String path, HLockManager lm, Semaphore failSemaphore) {
            this.numberLocks = numberLocks;
            this.path = path;
            this.lm = lm;
            this.executor = Executors.newFixedThreadPool(8);
            this.failSemaphore = failSemaphore;
            this.startLatch = new CountDownLatch(1);
            this.finishLatch = new CountDownLatch(numberLocks);
            this.failed = false;
        }

        private void go() throws InterruptedException {
            for (int i = 0; i < this.numberLocks; ++i) {
                this.executor.execute(new LockWorker(this));
            }
            this.startLatch.countDown();
        }

        private void waitToFinish() throws InterruptedException {
            this.finishLatch.await();
        }

        private void setFailed() {
            logger.error("Failed flag set");
            this.failed = true;
            List<Runnable> waiting = this.executor.shutdownNow();
            for (int i = 0; i < waiting.size() + 1; ++i) {
                this.finishLatch.countDown();
            }
        }

        private boolean isFailed() {
            return this.failed;
        }
    }
}

