/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import me.prettyprint.cassandra.model.AbstractSliceQuery;
import me.prettyprint.cassandra.model.ExecutingKeyspace;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.utils.StringUtils;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.query.QueryResult;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AbstractSliceQueryTest {
    private static final StringSerializer se = StringSerializer.get();
    private static final Keyspace ko = (Keyspace)Mockito.mock(ExecutingKeyspace.class);

    @Test
    public void testGetSetPredicate_columnNames() {
        ConcreteSliceQueury q = new ConcreteSliceQueury(ko, se, se, se);
        q.setColumnNames(new String[]{"1", "2", "3"});
        SlicePredicate p = q.getPredicate();
        Assert.assertEquals((long)3L, (long)p.getColumn_names().size());
        Assert.assertNull((Object)p.getSlice_range());
    }

    @Test
    public void testGetSetPredicate_range() {
        ConcreteSliceQueury q = new ConcreteSliceQueury(ko, se, se, se);
        q.setRange("1", "100", false, 10);
        SlicePredicate p = q.getPredicate();
        Assert.assertNull((Object)p.getColumn_names());
        SliceRange range = p.getSlice_range();
        Assert.assertNotNull((Object)range);
        Assert.assertArrayEquals((byte[])StringUtils.bytes((String)"1"), (byte[])range.getStart());
        Assert.assertArrayEquals((byte[])StringUtils.bytes((String)"100"), (byte[])range.getFinish());
        Assert.assertEquals((long)10L, (long)range.getCount());
    }

    private static class ConcreteSliceQueury<K, N, V, T>
    extends AbstractSliceQuery<K, N, V, T> {
        ConcreteSliceQueury(Keyspace k, Serializer<K> keySerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
            super(k, keySerializer, nameSerializer, valueSerializer);
        }

        public QueryResult<T> execute() {
            return null;
        }
    }
}

