/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import junit.framework.Assert;
import me.prettyprint.cassandra.model.ColumnSliceImpl;
import me.prettyprint.cassandra.serializers.ByteBufferSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.hector.api.Serializer;
import org.apache.cassandra.thrift.Column;
import org.junit.Test;

public class ColumnSliceTest {
    StringSerializer se = StringSerializer.get();
    LongSerializer le = LongSerializer.get();

    @Test
    public void testConstruction() {
        ArrayList<Column> tColumns = new ArrayList<Column>();
        ColumnSliceImpl slice = new ColumnSliceImpl(tColumns, (Serializer)this.se, (Serializer)this.le);
        Assert.assertTrue((boolean)slice.getColumns().isEmpty());
        Column column = new Column(ByteBuffer.wrap(new byte[0]));
        column.setValue(ByteBuffer.wrap(new byte[0]));
        column.setTimestamp(0L);
        tColumns.add(column);
        slice = new ColumnSliceImpl(tColumns, (Serializer)this.se, (Serializer)this.le);
        Assert.assertEquals((int)1, (int)slice.getColumns().size());
        tColumns = new ArrayList();
        column = new Column(this.se.toByteBuffer("1"));
        column.setValue(this.le.toByteBuffer(Long.valueOf(1L)));
        column.setTimestamp(0L);
        tColumns.add(column);
        slice = new ColumnSliceImpl(tColumns, (Serializer)this.se, (Serializer)this.le);
        Assert.assertEquals((Object)1L, (Object)slice.getColumnByName((Object)"1").getValue());
    }

    @Test
    public void testMultiCallOnByteBuffer() {
        ArrayList<Column> tColumns = new ArrayList<Column>();
        Column column = new Column(this.se.toByteBuffer("1"));
        column.setValue(ByteBuffer.wrap("colvalue".getBytes()));
        column.setTimestamp(0L);
        tColumns.add(column);
        ColumnSliceImpl slice = new ColumnSliceImpl(tColumns, (Serializer)this.se, (Serializer)ByteBufferSerializer.get());
        ByteBuffer value = (ByteBuffer)slice.getColumnByName((Object)"1").getValue();
        Assert.assertEquals((String)"colvalue", (String)this.se.fromByteBuffer(value));
        value.rewind();
        Assert.assertEquals((String)"colvalue", (String)this.se.fromByteBuffer(value));
        value.rewind();
        Assert.assertEquals((String)"colvalue", (String)this.se.fromByteBuffer(value));
    }
}

