/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.util.HashMap;
import java.util.Map;
import me.prettyprint.cassandra.model.ConfigurableConsistencyLevel;
import me.prettyprint.cassandra.service.OperationType;
import me.prettyprint.hector.api.HConsistencyLevel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConfigurableConsistencyLevelTest {
    private ConfigurableConsistencyLevel configurableConsistencyLevel;
    private Map<String, HConsistencyLevel> clmap;

    @Before
    public void setup() {
        this.configurableConsistencyLevel = new ConfigurableConsistencyLevel();
        this.clmap = new HashMap<String, HConsistencyLevel>();
        this.clmap.put("MyColumnFamily", HConsistencyLevel.ONE);
        this.configurableConsistencyLevel.setReadCfConsistencyLevels(this.clmap);
        this.configurableConsistencyLevel.setWriteCfConsistencyLevels(this.clmap);
    }

    @Test
    public void testReadWriteSame() {
        Assert.assertEquals((Object)HConsistencyLevel.ONE, (Object)this.configurableConsistencyLevel.get(OperationType.READ, "MyColumnFamily"));
    }

    @Test
    public void testDefaults() {
        this.configurableConsistencyLevel.setDefaultWriteConsistencyLevel(HConsistencyLevel.ALL);
        this.configurableConsistencyLevel.setWriteCfConsistencyLevels(new HashMap());
        Assert.assertEquals((Object)HConsistencyLevel.ALL, (Object)this.configurableConsistencyLevel.get(OperationType.WRITE, "MyColumnFamily"));
    }

    @Test
    public void testSetRuntimeCl() {
        this.configurableConsistencyLevel.setConsistencyLevelForCfOperation(HConsistencyLevel.ANY, "OtherCf", OperationType.READ);
        Assert.assertEquals((Object)HConsistencyLevel.ANY, (Object)this.configurableConsistencyLevel.get(OperationType.READ, "OtherCf"));
    }
}

