/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.nio.ByteBuffer;
import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.model.CqlQuery;
import me.prettyprint.cassandra.model.CqlRows;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.Row;
import me.prettyprint.hector.api.exceptions.HInvalidRequestException;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.query.QueryResult;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CqlQueryTest
extends BaseEmbededServerSetupTest {
    private static final String KEYSPACE = "Keyspace1";
    private static final StringSerializer se = new StringSerializer();
    private static final LongSerializer le = new LongSerializer();
    private Cluster cluster;
    private Keyspace keyspace;
    private String cf = "StandardLong1";

    @Before
    public void setupCase() {
        this.cluster = HFactory.getOrCreateCluster((String)"MyCluster", (String)"127.0.0.1:9170");
        this.keyspace = HFactory.createKeyspace((String)KEYSPACE, (Cluster)this.cluster);
        HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se).addInsertion((Object)"cqlQueryTest_key1", this.cf, HFactory.createColumn((Object)"birthyear", (Object)1974L, (Serializer)se, (Serializer)le)).addInsertion((Object)"cqlQueryTest_key1", this.cf, HFactory.createColumn((Object)"birthmonth", (Object)4L, (Serializer)se, (Serializer)le)).addInsertion((Object)"cqlQueryTest_key2", this.cf, HFactory.createColumn((Object)"birthyear", (Object)1975L, (Serializer)se, (Serializer)le)).addInsertion((Object)"cqlQueryTest_key2", this.cf, HFactory.createColumn((Object)"birthmonth", (Object)4L, (Serializer)se, (Serializer)le)).addInsertion((Object)"cqlQueryTest_key3", this.cf, HFactory.createColumn((Object)"birthyear", (Object)1975L, (Serializer)se, (Serializer)le)).addInsertion((Object)"cqlQueryTest_key3", this.cf, HFactory.createColumn((Object)"birthmonth", (Object)5L, (Serializer)se, (Serializer)le)).addInsertion((Object)"cqlQueryTest_key4", this.cf, HFactory.createColumn((Object)"birthyear", (Object)1975L, (Serializer)se, (Serializer)le)).addInsertion((Object)"cqlQueryTest_key4", this.cf, HFactory.createColumn((Object)"birthmonth", (Object)6L, (Serializer)se, (Serializer)le)).addInsertion((Object)"cqlQueryTest_key5", this.cf, HFactory.createColumn((Object)"birthyear", (Object)1975L, (Serializer)se, (Serializer)le)).addInsertion((Object)"cqlQueryTest_key5", this.cf, HFactory.createColumn((Object)"birthmonth", (Object)7L, (Serializer)se, (Serializer)le)).addInsertion((Object)"cqlQueryTest_key6", this.cf, HFactory.createColumn((Object)"birthyear", (Object)1976L, (Serializer)se, (Serializer)le)).addInsertion((Object)"cqlQueryTest_key6", this.cf, HFactory.createColumn((Object)"birthmonth", (Object)6L, (Serializer)se, (Serializer)le)).execute();
    }

    @Test
    public void testSimpleSelect() {
        CqlQuery cqlQuery = new CqlQuery(this.keyspace, (Serializer)se, (Serializer)se, (Serializer)le);
        cqlQuery.setQuery("select * from StandardLong1");
        QueryResult result = cqlQuery.execute();
        CqlRows rows = (CqlRows)result.get();
        Assert.assertNotNull((Object)((Row)rows.getList().get(0)).getColumnSlice().getColumnByName((Object)"KEY"));
        Assert.assertEquals((long)6L, (long)rows.getCount());
    }

    @Test
    public void testSimpleSelect20() {
        CqlQuery cqlQuery = new CqlQuery(this.keyspace, (Serializer)se, (Serializer)se, (Serializer)le);
        cqlQuery.setQuery("select birth .. birthzz from StandardLong1");
        cqlQuery.setCqlVersion("2.0.0");
        QueryResult result = cqlQuery.execute();
        CqlRows rows = (CqlRows)result.get();
        Assert.assertEquals((long)6L, (long)rows.getCount());
    }

    @Test
    public void testSelectAllSuppressesKeyColumn() {
        CqlQuery cqlQuery = new CqlQuery(this.keyspace, (Serializer)se, (Serializer)se, (Serializer)le);
        cqlQuery.setQuery("select * from StandardLong1");
        cqlQuery.setSuppressKeyInColumns(true);
        QueryResult result = cqlQuery.execute();
        CqlRows rows = (CqlRows)result.get();
        Assert.assertNull((Object)((Row)rows.getList().get(0)).getColumnSlice().getColumnByName((Object)"KEY"));
        Assert.assertNull((Object)((Row)rows.getList().get(3)).getColumnSlice().getColumnByName((Object)"KEY"));
        Assert.assertEquals((long)6L, (long)rows.getCount());
    }

    @Test
    public void testCountQuery() {
        CqlQuery cqlQuery = new CqlQuery(this.keyspace, (Serializer)se, (Serializer)se, (Serializer)le);
        cqlQuery.setQuery("SELECT COUNT(*) FROM StandardLong1 WHERE KEY in ('cqlQueryTest_key1', 'cqlQueryTest_key2')");
        QueryResult result = cqlQuery.execute();
        Assert.assertEquals((long)2L, (long)((CqlRows)result.get()).getAsCount());
    }

    @Test(expected=HInvalidRequestException.class)
    public void testSyntaxFailQuery() {
        CqlQuery cqlQuery = new CqlQuery(this.keyspace, (Serializer)se, (Serializer)se, (Serializer)le);
        cqlQuery.setQuery("SELECT COUNT(*) FROM Standard1 WHERE KEY = 'cqlQueryTest_key1'");
        cqlQuery.execute();
    }

    @Test
    public void testInsertSyntax() {
        CqlQuery cqlQuery = new CqlQuery(this.keyspace, (Serializer)se, (Serializer)se, (Serializer)le);
        cqlQuery.setQuery("update StandardLong1 set 'birthyear' = '1976' WHERE KEY = 'cqlQueryTest_key7'");
        cqlQuery.execute();
    }

    @Test
    public void testInsertSyntaxHex() {
        CqlQuery cqlQuery = new CqlQuery(this.keyspace, (Serializer)se, (Serializer)se, (Serializer)le);
        String query = String.format("update Standard1 set '%s' = '%s' WHERE KEY = '%s'", ByteBufferUtil.bytesToHex((ByteBuffer)se.toByteBuffer("birthyear")), ByteBufferUtil.bytesToHex((ByteBuffer)se.toByteBuffer("1976")), ByteBufferUtil.bytesToHex((ByteBuffer)se.toByteBuffer("mykey1")));
        cqlQuery.setQuery(query);
        cqlQuery.execute();
    }
}

