/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.service.CassandraHostConfigurator;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.exceptions.HInvalidRequestException;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.SliceQuery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GetSliceQueryTest
extends BaseEmbededServerSetupTest {
    private static final String KEYSPACE = "Keyspace1";
    private static final StringSerializer se = new StringSerializer();
    private static final LongSerializer le = new LongSerializer();
    private Cluster cluster;
    private Keyspace keyspace;
    private String cf = "Standard1";

    @Before
    public void setupCase() {
        CassandraHostConfigurator chc = new CassandraHostConfigurator("127.0.0.1:9170");
        chc.setMaxActive(2);
        this.cluster = HFactory.getOrCreateCluster((String)"MyCluster", (CassandraHostConfigurator)chc);
        this.keyspace = HFactory.createKeyspace((String)KEYSPACE, (Cluster)this.cluster);
        HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se).addInsertion((Object)"getSliceTest_key3", this.cf, HFactory.createColumn((Object)"birthyear1", (Object)1974L, (Serializer)se, (Serializer)le)).addInsertion((Object)"getSliceTest_key3", this.cf, HFactory.createColumn((Object)"birthyear2", (Object)1975L, (Serializer)se, (Serializer)le)).addInsertion((Object)"getSliceTest_key3", this.cf, HFactory.createColumn((Object)"birthyear3", (Object)1976L, (Serializer)se, (Serializer)le)).addInsertion((Object)"getSliceTest_key3", this.cf, HFactory.createColumn((Object)"birthyear4", (Object)1977L, (Serializer)se, (Serializer)le)).addInsertion((Object)"getSliceTest_key3", this.cf, HFactory.createColumn((Object)"birthyear5", (Object)1978L, (Serializer)se, (Serializer)le)).addInsertion((Object)"getSliceTest_key3", this.cf, HFactory.createColumn((Object)"birthyear6", (Object)1979L, (Serializer)se, (Serializer)le)).execute();
    }

    @Test
    public void testNullKeyInvalidQuery() {
        SliceQuery sq = HFactory.createSliceQuery((Keyspace)this.keyspace, (Serializer)se, (Serializer)se, (Serializer)le);
        sq.setColumnFamily(this.cf);
        sq.setRange((Object)"birthyear1", (Object)"birthyear4", false, 100);
        try {
            sq.execute();
            Assert.fail();
        }
        catch (HInvalidRequestException he) {
            // empty catch block
        }
        sq.setKey((Object)"getSliceTest_key3");
        QueryResult result = sq.execute();
        Assert.assertEquals((long)4L, (long)((ColumnSlice)result.get()).getColumns().size());
    }
}

