/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.util.NoSuchElementException;
import java.util.UUID;
import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.serializers.UUIDSerializer;
import me.prettyprint.cassandra.service.HColumnFamilyImpl;
import me.prettyprint.cassandra.utils.TimeUUIDUtils;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HColumnFamilyTest
extends BaseEmbededServerSetupTest {
    private Keyspace keyspace;
    private UUID timeUUID;

    @Before
    public void setupLocal() {
        Cluster cluster = HFactory.getOrCreateCluster((String)"MyCluster", (String)"127.0.0.1:9170");
        this.keyspace = HFactory.createKeyspace((String)"Keyspace1", (Cluster)cluster);
        Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)StringSerializer.get());
        mutator.addInsertion((Object)"zznate", "Standard1", HFactory.createStringColumn((String)"email", (String)"nate@datastax.com"));
        mutator.addInsertion((Object)"zznate", "Standard1", HFactory.createColumn((Object)"int", (Object)1, (Serializer)StringSerializer.get(), (Serializer)IntegerSerializer.get()));
        mutator.addInsertion((Object)"zznate", "Standard1", HFactory.createColumn((Object)"long", (Object)1L, (Serializer)StringSerializer.get(), (Serializer)LongSerializer.get()));
        this.timeUUID = TimeUUIDUtils.getTimeUUID((long)System.currentTimeMillis());
        mutator.addInsertion((Object)"zznate", "Standard1", HFactory.createColumn((Object)"uuid", (Object)this.timeUUID, (Serializer)StringSerializer.get(), (Serializer)UUIDSerializer.get()));
        mutator.execute();
    }

    @Test
    public void testColumnFamilySetup() {
        HColumnFamilyImpl columnFamily = new HColumnFamilyImpl(this.keyspace, "Standard1", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        columnFamily.addKey((Object)"zznate");
        Assert.assertEquals((long)1L, (long)columnFamily.getInt((Object)"int"));
        Assert.assertEquals((Object)"nate@datastax.com", (Object)columnFamily.getString((Object)"email"));
        Assert.assertEquals((long)1L, (long)columnFamily.getLong((Object)"long"));
        Assert.assertEquals((Object)this.timeUUID, (Object)columnFamily.getUUID((Object)"uuid"));
    }

    @Test
    public void testColumnFamilyReadahead() {
        HColumnFamilyImpl columnFamily = new HColumnFamilyImpl(this.keyspace, "Standard1", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        columnFamily.addKey((Object)"zznate").setCount(10);
        Assert.assertEquals((long)4L, (long)columnFamily.getColumns().size());
        Assert.assertEquals((long)1L, (long)columnFamily.getInt((Object)"int"));
        Assert.assertEquals((Object)"nate@datastax.com", (Object)columnFamily.getString((Object)"email"));
        Assert.assertEquals((long)1L, (long)columnFamily.getLong((Object)"long"));
        Assert.assertEquals((Object)this.timeUUID, (Object)columnFamily.getUUID((Object)"uuid"));
    }

    @Test
    public void testClearAndRecall() {
        HColumnFamilyImpl columnFamily = new HColumnFamilyImpl(this.keyspace, "Standard1", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        columnFamily.addKey((Object)"zznate").setCount(10);
        Assert.assertEquals((long)4L, (long)columnFamily.getColumns().size());
        Assert.assertEquals((long)1L, (long)columnFamily.getInt((Object)"int"));
        Assert.assertEquals((Object)"nate@datastax.com", (Object)columnFamily.getString((Object)"email"));
        Assert.assertEquals((long)1L, (long)columnFamily.getLong((Object)"long"));
        Assert.assertEquals((Object)this.timeUUID, (Object)columnFamily.getUUID((Object)"uuid"));
        columnFamily.clear();
        Assert.assertNull((Object)columnFamily.getUUID((Object)"uuid"));
        Assert.assertEquals((long)4L, (long)columnFamily.getColumns().size());
        Assert.assertEquals((Object)this.timeUUID, (Object)columnFamily.getUUID((Object)"uuid"));
    }

    @Test
    public void testToggleMultiget() {
        Mutator mutator = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)StringSerializer.get());
        mutator.addInsertion((Object)"patricioe", "Standard1", HFactory.createStringColumn((String)"email", (String)"patricioe@datastax.com"));
        mutator.addInsertion((Object)"patricioe", "Standard1", HFactory.createColumn((Object)"int", (Object)2, (Serializer)StringSerializer.get(), (Serializer)IntegerSerializer.get()));
        mutator.addInsertion((Object)"patricioe", "Standard1", HFactory.createColumn((Object)"long", (Object)2L, (Serializer)StringSerializer.get(), (Serializer)LongSerializer.get()));
        this.timeUUID = TimeUUIDUtils.getTimeUUID((long)System.currentTimeMillis());
        mutator.addInsertion((Object)"patricioe", "Standard1", HFactory.createColumn((Object)"uuid", (Object)this.timeUUID, (Serializer)StringSerializer.get(), (Serializer)UUIDSerializer.get()));
        mutator.execute();
        HColumnFamilyImpl columnFamily = new HColumnFamilyImpl(this.keyspace, "Standard1", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
        columnFamily.addKey((Object)"zznate").addKey((Object)"patricioe").setCount(10);
        Assert.assertEquals((Object)"nate@datastax.com", (Object)columnFamily.getString((Object)"email"));
        Assert.assertTrue((boolean)columnFamily.hasNext());
        columnFamily.next();
        Assert.assertEquals((Object)"patricioe@datastax.com", (Object)columnFamily.getString((Object)"email"));
        Assert.assertFalse((boolean)columnFamily.hasNext());
        try {
            columnFamily.next();
            Assert.fail();
        }
        catch (NoSuchElementException nsee) {
            Assert.assertNotNull((Object)nsee);
        }
    }
}

