/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.model.IndexedSlicesQuery;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.OrderedRows;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.query.QueryResult;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexedSlicesQueryTest
extends BaseEmbededServerSetupTest {
    private static final String KEYSPACE = "Keyspace1";
    private static final StringSerializer se = new StringSerializer();
    private static final LongSerializer le = new LongSerializer();
    private Cluster cluster;
    private Keyspace keyspace;
    private String cf = "Indexed1";
    private static boolean inserted = false;

    @Before
    public void setupCase() {
        this.cluster = HFactory.getOrCreateCluster((String)"MyCluster", (String)"127.0.0.1:9170");
        this.keyspace = HFactory.createKeyspace((String)KEYSPACE, (Cluster)this.cluster);
        if (!inserted) {
            HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se).addInsertion((Object)"indexedSlicesTest_key1", this.cf, HFactory.createColumn((Object)"birthyear", (Object)1974L, (Serializer)se, (Serializer)le)).addInsertion((Object)"indexedSlicesTest_key1", this.cf, HFactory.createColumn((Object)"birthmonth", (Object)4L, (Serializer)se, (Serializer)le)).addInsertion((Object)"indexedSlicesTest_key2", this.cf, HFactory.createColumn((Object)"birthyear", (Object)1975L, (Serializer)se, (Serializer)le)).addInsertion((Object)"indexedSlicesTest_key2", this.cf, HFactory.createColumn((Object)"birthmonth", (Object)4L, (Serializer)se, (Serializer)le)).addInsertion((Object)"indexedSlicesTest_key3", this.cf, HFactory.createColumn((Object)"birthyear", (Object)1975L, (Serializer)se, (Serializer)le)).addInsertion((Object)"indexedSlicesTest_key3", this.cf, HFactory.createColumn((Object)"birthmonth", (Object)5L, (Serializer)se, (Serializer)le)).addInsertion((Object)"indexedSlicesTest_key4", this.cf, HFactory.createColumn((Object)"birthyear", (Object)1975L, (Serializer)se, (Serializer)le)).addInsertion((Object)"indexedSlicesTest_key4", this.cf, HFactory.createColumn((Object)"birthmonth", (Object)6L, (Serializer)se, (Serializer)le)).addInsertion((Object)"indexedSlicesTest_key5", this.cf, HFactory.createColumn((Object)"birthyear", (Object)1975L, (Serializer)se, (Serializer)le)).addInsertion((Object)"indexedSlicesTest_key5", this.cf, HFactory.createColumn((Object)"birthmonth", (Object)7L, (Serializer)se, (Serializer)le)).addInsertion((Object)"indexedSlicesTest_key6", this.cf, HFactory.createColumn((Object)"birthyear", (Object)1976L, (Serializer)se, (Serializer)le)).addInsertion((Object)"indexedSlicesTest_key6", this.cf, HFactory.createColumn((Object)"birthmonth", (Object)6L, (Serializer)se, (Serializer)le)).execute();
            inserted = true;
        }
    }

    @After
    public void teardownCase() {
        this.keyspace = null;
        this.cluster = null;
    }

    @Test
    public void testInsertGetRemove() {
        IndexedSlicesQuery indexedSlicesQuery = new IndexedSlicesQuery(this.keyspace, (Serializer)se, (Serializer)se, (Serializer)le);
        indexedSlicesQuery.addEqualsExpression((Object)"birthyear", (Object)1975L);
        indexedSlicesQuery.setColumnNames((Object[])new String[]{"birthmonth"});
        indexedSlicesQuery.setColumnFamily(this.cf);
        indexedSlicesQuery.setStartKey((Object)"");
        QueryResult result = indexedSlicesQuery.execute();
        Assert.assertEquals((long)4L, (long)((OrderedRows)result.get()).getList().size());
    }

    @Test
    public void testMultiClause() {
        QueryResult result = new IndexedSlicesQuery(this.keyspace, (Serializer)se, (Serializer)se, (Serializer)le).addEqualsExpression((Object)"birthyear", (Object)1975L).addGteExpression((Object)"birthmonth", (Object)4L).addLteExpression((Object)"birthmonth", (Object)6L).setColumnNames((Object[])new String[]{"birthyear"}).setColumnFamily(this.cf).setStartKey((Object)"").execute();
        Assert.assertEquals((long)3L, (long)((OrderedRows)result.get()).getList().size());
    }

    @Test
    public void testEqClauseMiss() {
        QueryResult result = new IndexedSlicesQuery(this.keyspace, (Serializer)se, (Serializer)se, (Serializer)le).addEqualsExpression((Object)"birthyear", (Object)5L).addGteExpression((Object)"birthmonth", (Object)4L).addLteExpression((Object)"birthmonth", (Object)6L).setColumnNames((Object[])new String[]{"birthyear"}).setColumnFamily(this.cf).setStartKey((Object)"").execute();
        Assert.assertEquals((long)0L, (long)((OrderedRows)result.get()).getList().size());
    }

    @Test
    public void testRowCountLimit() {
        QueryResult result = new IndexedSlicesQuery(this.keyspace, (Serializer)se, (Serializer)se, (Serializer)le).addEqualsExpression((Object)"birthyear", (Object)1975L).addGteExpression((Object)"birthmonth", (Object)4L).addLteExpression((Object)"birthmonth", (Object)6L).setColumnNames((Object[])new String[]{"birthyear"}).setColumnFamily(this.cf).setStartKey((Object)"").setRowCount(2).execute();
        Assert.assertEquals((long)2L, (long)((OrderedRows)result.get()).getList().size());
    }
}

