/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.util.ArrayList;
import java.util.Map;
import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.model.MultigetCountQuery;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.QueryResult;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultigetCountQueryTest
extends BaseEmbededServerSetupTest {
    private static final StringSerializer se = new StringSerializer();
    private Cluster cluster;
    private Keyspace keyspace;

    @Before
    public void setupCase() {
        this.cluster = HFactory.getOrCreateCluster((String)"Test Cluster", (String)"127.0.0.1:9170");
        this.keyspace = HFactory.createKeyspace((String)"Keyspace1", (Cluster)this.cluster);
    }

    @After
    public void teardownCase() {
        this.keyspace = null;
        this.cluster = null;
    }

    @Test
    public void testMultigetCount() {
        String cf = "Standard1";
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            String key = "k" + i;
            m.addInsertion((Object)key, cf, HFactory.createColumn((Object)"name", (Object)("value" + i), (Serializer)se, (Serializer)se));
            keys.add(key);
        }
        m.execute();
        MultigetCountQuery mcq = new MultigetCountQuery(this.keyspace, (Serializer)se, (Serializer)se);
        mcq.setColumnFamily(cf);
        mcq.setColumnNames((Object[])new String[]{"name"});
        mcq.setKeys((Object[])keys.toArray(new String[0]));
        QueryResult result = mcq.execute();
        Assert.assertEquals((long)5L, (long)((Map)result.get()).size());
    }

    public void testMultigetSuperCount() {
    }

    public void testMultigetSubCount() {
    }
}

