/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import java.util.ArrayList;
import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.model.thrift.ThriftCounterColumnQuery;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.utils.StringUtils;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hector.api.beans.HCounterColumn;
import me.prettyprint.hector.api.beans.HSuperColumn;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.mutation.MutationResult;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hector.api.query.ColumnQuery;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.SuperColumnQuery;
import org.apache.cassandra.thrift.ColumnPath;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MutatorTest
extends BaseEmbededServerSetupTest {
    private static final StringSerializer se = new StringSerializer();
    private Cluster cluster;
    private Keyspace keyspace;

    @Before
    public void setupCase() {
        this.cluster = HFactory.getOrCreateCluster((String)"Test Cluster", (String)"127.0.0.1:9170");
        this.keyspace = HFactory.createKeyspace((String)"Keyspace1", (Cluster)this.cluster);
    }

    @After
    public void teardownCase() {
        this.keyspace = null;
        this.cluster = null;
    }

    @Test
    public void testInsert() {
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        MutationResult mr = m.insert((Object)"k", "Standard1", HFactory.createColumn((Object)"name", (Object)"value", (Serializer)se, (Serializer)se));
        Assert.assertTrue((String)"Execution time on single insert should be > 0", (mr.getExecutionTimeMicro() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should have operated on a host", (mr.getHostUsed() != null ? 1 : 0) != 0);
        this.assertColumnExists("Keyspace1", "Standard1", "k", "name");
    }

    @Test
    public void testInsertAndDeleteSuper() {
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        ArrayList<HColumn> columnList = new ArrayList<HColumn>();
        columnList.add(HFactory.createColumn((Object)"name", (Object)"value", (Serializer)se, (Serializer)se));
        HSuperColumn superColumn = HFactory.createSuperColumn((Object)"super_name", columnList, (Serializer)se, (Serializer)se, (Serializer)se);
        MutationResult r = m.insert((Object)"sk", "Super1", superColumn);
        Assert.assertTrue((String)"Execute time should be > 0", (r.getExecutionTimeMicro() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should have operated on a host", (r.getHostUsed() != null ? 1 : 0) != 0);
        SuperColumnQuery scq = HFactory.createSuperColumnQuery((Keyspace)this.keyspace, (Serializer)se, (Serializer)se, (Serializer)se, (Serializer)se);
        scq.setColumnFamily("Super1");
        scq.setKey((Object)"sk");
        scq.setSuperName((Object)"super_name");
        Assert.assertEquals((Object)"super_name", (Object)((HSuperColumn)scq.execute().get()).getName());
        m.superDelete((Object)"sk", "Super1", (Object)"super_name", (Serializer)se);
        scq = HFactory.createSuperColumnQuery((Keyspace)this.keyspace, (Serializer)se, (Serializer)se, (Serializer)se, (Serializer)se);
        scq.setColumnFamily("Super1");
        scq.setKey((Object)"sk");
        scq.setSuperName((Object)"super_name");
        Assert.assertNull((String)"super_name", (Object)scq.execute().get());
    }

    @Test
    public void testSubDelete() {
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        ArrayList<HColumn> columnList = new ArrayList<HColumn>();
        columnList.add(HFactory.createColumn((Object)"col_1", (Object)"val_1", (Serializer)se, (Serializer)se));
        columnList.add(HFactory.createColumn((Object)"col_2", (Object)"val_2", (Serializer)se, (Serializer)se));
        columnList.add(HFactory.createColumn((Object)"col_3", (Object)"val_3", (Serializer)se, (Serializer)se));
        HSuperColumn superColumn = HFactory.createSuperColumn((Object)"super_name", columnList, (Serializer)se, (Serializer)se, (Serializer)se);
        m.insert((Object)"sk1", "Super1", superColumn);
        SuperColumnQuery scq = HFactory.createSuperColumnQuery((Keyspace)this.keyspace, (Serializer)se, (Serializer)se, (Serializer)se, (Serializer)se);
        scq.setColumnFamily("Super1");
        scq.setKey((Object)"sk1");
        scq.setSuperName((Object)"super_name");
        Assert.assertEquals((long)3L, (long)((HSuperColumn)scq.execute().get()).getColumns().size());
        m.discardPendingMutations();
        m.addSubDelete((Object)"sk1", "Super1", (Object)"super_name", (Object)"col_1", (Serializer)se, (Serializer)se);
        m.execute();
        Assert.assertEquals((long)2L, (long)((HSuperColumn)scq.execute().get()).getColumns().size());
    }

    @Test
    public void testSubDeleteHSuperColumn() {
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        ArrayList<HColumn> columnList = new ArrayList<HColumn>();
        columnList.add(HFactory.createColumn((Object)"col_1", (Object)"val_1", (Serializer)se, (Serializer)se));
        columnList.add(HFactory.createColumn((Object)"col_2", (Object)"val_2", (Serializer)se, (Serializer)se));
        columnList.add(HFactory.createColumn((Object)"col_3", (Object)"val_3", (Serializer)se, (Serializer)se));
        HSuperColumn superColumn = HFactory.createSuperColumn((Object)"super_name", columnList, (Serializer)se, (Serializer)se, (Serializer)se);
        m.insert((Object)"sk1", "Super1", superColumn);
        SuperColumnQuery scq = HFactory.createSuperColumnQuery((Keyspace)this.keyspace, (Serializer)se, (Serializer)se, (Serializer)se, (Serializer)se);
        scq.setColumnFamily("Super1");
        scq.setKey((Object)"sk1");
        scq.setSuperName((Object)"super_name");
        Assert.assertEquals((long)3L, (long)((HSuperColumn)scq.execute().get()).getColumns().size());
        m.discardPendingMutations();
        columnList.remove(1);
        columnList.remove(0);
        superColumn.setSubcolumns(columnList);
        m.addSubDelete((Object)"sk1", "Super1", superColumn);
        m.execute();
        Assert.assertEquals((long)2L, (long)((HSuperColumn)scq.execute().get()).getColumns().size());
    }

    @Test
    public void testBatchMutationManagement() {
        int i;
        String cf = "Standard1";
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        for (int i2 = 0; i2 < 5; ++i2) {
            m.addInsertion((Object)("k" + i2), cf, HFactory.createColumn((Object)"name", (Object)("value" + i2), (Serializer)se, (Serializer)se));
        }
        Assert.assertEquals((long)5L, (long)m.getPendingMutationCount());
        MutationResult r = m.execute();
        Assert.assertTrue((String)"Execute time should be > 0", (r.getExecutionTimeMicro() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should have operated on a host", (r.getHostUsed() != null ? 1 : 0) != 0);
        for (i = 0; i < 5; ++i) {
            this.assertColumnExists("Keyspace1", "Standard1", "k" + i, "name");
        }
        r = m.execute();
        Assert.assertEquals((String)"Execute time should be 0", (long)0L, (long)r.getExecutionTimeMicro());
        for (i = 0; i < 5; ++i) {
            m.addInsertion((Object)("k" + i), cf, HFactory.createColumn((Object)"name", (Object)("value" + i), (Serializer)se, (Serializer)se));
        }
        m.discardPendingMutations();
        r = m.execute();
        Assert.assertEquals((String)"Execute time should be 0", (long)0L, (long)r.getExecutionTimeMicro());
        Assert.assertTrue((String)"Should have operated with a null host", (r.getHostUsed() == null ? 1 : 0) != 0);
        for (i = 0; i < 5; ++i) {
            m.addDeletion((Object)("k" + i), cf, (Object)"name", (Serializer)se);
        }
        m.execute();
    }

    @Test
    public void testRowDeletion() {
        String cf = "Standard1";
        long initialTime = this.keyspace.createClock();
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        for (int i = 0; i < 5; ++i) {
            m.addInsertion((Object)("key" + i), cf, HFactory.createColumn((Object)"name", (Object)("value" + i), (Serializer)se, (Serializer)se));
        }
        m.execute();
        m.addDeletion((Object)"key0", cf, null, (Serializer)se, initialTime - 100L);
        m.execute();
        QueryResult columnResult = HFactory.createColumnQuery((Keyspace)this.keyspace, (Serializer)se, (Serializer)se, (Serializer)se).setColumnFamily(cf).setKey((Object)"key0").setName((Object)"name").execute();
        Assert.assertEquals((Object)"value0", (Object)((HColumn)columnResult.get()).getValue());
        for (int i = 0; i < 5; ++i) {
            m.addDeletion((Object)("key" + i), cf, null, (Serializer)se);
        }
        m.execute();
        columnResult = HFactory.createColumnQuery((Keyspace)this.keyspace, (Serializer)se, (Serializer)se, (Serializer)se).setColumnFamily(cf).setKey((Object)"key0").setName((Object)"name").execute();
        Assert.assertNull((Object)columnResult.get());
    }

    @Test
    public void testInsertCounter() {
        Mutator m = HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se);
        MutationResult mr = m.insertCounter((Object)"k", "Counter1", HFactory.createCounterColumn((String)"name", (long)5L));
        Assert.assertTrue((String)"Execution time on single counter insert should be > 0", (mr.getExecutionTimeMicro() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should have operated on a host", (mr.getHostUsed() != null ? 1 : 0) != 0);
        ThriftCounterColumnQuery counter = new ThriftCounterColumnQuery(this.keyspace, (Serializer)se, (Serializer)se);
        counter.setColumnFamily("Counter1").setKey((Object)"k").setName((Object)"name");
        Assert.assertEquals((Object)new Long(5L), (Object)((HCounterColumn)counter.execute().get()).getValue());
    }

    private void assertColumnExists(String keyspace, String cf, String key, String column) {
        ColumnPath cp = new ColumnPath(cf);
        cp.setColumn(StringUtils.bytes((String)column));
        Keyspace ks = HFactory.createKeyspace((String)keyspace, (Cluster)this.cluster);
        ColumnQuery columnQuery = HFactory.createStringColumnQuery((Keyspace)ks);
        Assert.assertNotNull((String)String.format("Should have value for %s.%s[%s][%s]", keyspace, cf, key, column), (Object)((HColumn)columnQuery.setColumnFamily(cf).setKey((Object)key).setName((Object)column).execute().get()).getValue());
    }
}

