/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model;

import me.prettyprint.cassandra.BaseEmbededServerSetupTest;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.CounterRow;
import me.prettyprint.hector.api.beans.OrderedCounterRows;
import me.prettyprint.hector.api.factory.HFactory;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.RangeSlicesCounterQuery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RangeSlicesCounterQueryTest
extends BaseEmbededServerSetupTest {
    private static final String KEYSPACE = "Keyspace1";
    private static final StringSerializer se = new StringSerializer();
    private Cluster cluster;
    private Keyspace keyspace;
    private String cf = "Counter2";

    @Before
    public void setupCase() {
        this.cluster = HFactory.getOrCreateCluster((String)"MyCluster", (String)"127.0.0.1:9170");
        this.keyspace = HFactory.createKeyspace((String)KEYSPACE, (Cluster)this.cluster);
        HFactory.createMutator((Keyspace)this.keyspace, (Serializer)se).addCounter((Object)"ranageSlicesCounterTest_key1", this.cf, HFactory.createCounterColumn((String)"alpha", (long)1L)).addCounter((Object)"ranageSlicesCounterTest_key1", this.cf, HFactory.createCounterColumn((String)"beta", (long)2L)).addCounter((Object)"ranageSlicesCounterTest_key2", this.cf, HFactory.createCounterColumn((String)"alpha", (long)1L)).addCounter((Object)"ranageSlicesCounterTest_key2", this.cf, HFactory.createCounterColumn((String)"beta", (long)2L)).addCounter((Object)"ranageSlicesCounterTest_key3", this.cf, HFactory.createCounterColumn((String)"alpha", (long)1L)).addCounter((Object)"ranageSlicesCounterTest_key3", this.cf, HFactory.createCounterColumn((String)"beta", (long)2L)).addCounter((Object)"ranageSlicesCounterTest_key4", this.cf, HFactory.createCounterColumn((String)"alpha", (long)1L)).addCounter((Object)"ranageSlicesCounterTest_key4", this.cf, HFactory.createCounterColumn((String)"beta", (long)2L)).addCounter((Object)"ranageSlicesCounterTest_key5", this.cf, HFactory.createCounterColumn((String)"alpha", (long)1L)).addCounter((Object)"ranageSlicesCounterTest_key5", this.cf, HFactory.createCounterColumn((String)"beta", (long)2L)).addCounter((Object)"ranageSlicesCounterTest_key6", this.cf, HFactory.createCounterColumn((String)"alpha", (long)1L)).addCounter((Object)"ranageSlicesCounterTest_key6", this.cf, HFactory.createCounterColumn((String)"beta", (long)2L)).execute();
    }

    @Test
    public void testKeysOnlyPredicate() {
        RangeSlicesCounterQuery rangeSlicesQuery = HFactory.createRangeSlicesCounterQuery((Keyspace)this.keyspace, (Serializer)se, (Serializer)se);
        QueryResult result = rangeSlicesQuery.setColumnFamily(this.cf).setKeys((Object)"", (Object)"").setReturnKeysOnly().execute();
        OrderedCounterRows orderedRows = (OrderedCounterRows)result.get();
        CounterRow row = (CounterRow)orderedRows.iterator().next();
        Assert.assertNotNull((Object)row.getKey());
        Assert.assertEquals((long)0L, (long)row.getColumnSlice().getColumns().size());
        result = rangeSlicesQuery.setColumnNames((Object[])new String[]{"alpha", "beta"}).setRowCount(5).execute();
        orderedRows = (OrderedCounterRows)result.get();
        row = (CounterRow)orderedRows.iterator().next();
        Assert.assertNotNull((Object)row.getKey());
        Assert.assertEquals((long)2L, (long)row.getColumnSlice().getColumns().size());
    }
}

