/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.serializers;

import java.nio.ByteBuffer;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.junit.Assert;
import org.junit.Test;

public class IntegerSerializerTest {
    static IntegerSerializer ext = IntegerSerializer.get();

    @Test
    public void testConversions() {
        this.test(0);
        this.test(1);
        this.test(-1);
        this.test(Integer.MAX_VALUE);
        this.test(Integer.MIN_VALUE);
        this.test(null);
    }

    @Test
    public void testFromCassandra() {
        Assert.assertEquals((Object)new Integer(1), (Object)ext.fromByteBuffer(ByteBufferUtil.bytes((int)1)));
        Assert.assertEquals((Object)new Integer(-1), (Object)ext.fromByteBuffer(ByteBufferUtil.bytes((int)-1)));
        Assert.assertEquals((Object)new Integer(0), (Object)ext.fromByteBuffer(ByteBufferUtil.bytes((int)0)));
        Assert.assertEquals((Object)new Integer(Integer.MAX_VALUE), (Object)ext.fromByteBuffer(ByteBufferUtil.bytes((int)Integer.MAX_VALUE)));
        Assert.assertEquals((Object)new Integer(Integer.MIN_VALUE), (Object)ext.fromByteBuffer(ByteBufferUtil.bytes((int)Integer.MIN_VALUE)));
    }

    @Test
    public void testFromCassandraAsBytes() {
        Assert.assertEquals((Object)new Integer(1), (Object)ext.fromBytes(ByteBufferUtil.bytes((int)1).array()));
        Assert.assertEquals((Object)new Integer(-1), (Object)ext.fromBytes(ByteBufferUtil.bytes((int)-1).array()));
        Assert.assertEquals((Object)new Integer(0), (Object)ext.fromBytes(ByteBufferUtil.bytes((int)0).array()));
        Assert.assertEquals((Object)new Integer(Integer.MAX_VALUE), (Object)ext.fromBytes(ByteBufferUtil.bytes((int)Integer.MAX_VALUE).array()));
        Assert.assertEquals((Object)new Integer(Integer.MIN_VALUE), (Object)ext.fromBytes(ByteBufferUtil.bytes((int)Integer.MIN_VALUE).array()));
    }

    private void test(Integer number) {
        Assert.assertEquals((Object)number, (Object)ext.fromByteBuffer(ext.toByteBuffer(number)));
        if (number != null) {
            ByteBuffer b = ByteBuffer.allocate(4);
            b.putInt(number);
            b.rewind();
            Assert.assertEquals((Object)number, (Object)ext.fromByteBuffer(b));
        }
    }
}

