/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.serializers;

import java.nio.ByteBuffer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.junit.Assert;
import org.junit.Test;

public class LongSerializerTest {
    static LongSerializer ext = LongSerializer.get();

    @Test
    public void testConversions() {
        this.test(0L);
        this.test(1L);
        this.test(-1L);
        this.test(Long.MAX_VALUE);
        this.test(Long.MIN_VALUE);
        this.test(null);
    }

    @Test
    public void testFromCassandra() {
        Assert.assertEquals((Object)new Long(1L), (Object)ext.fromByteBuffer(ByteBufferUtil.bytes((long)1L)));
        Assert.assertEquals((Object)new Long(0L), (Object)ext.fromByteBuffer(ByteBufferUtil.bytes((long)0L)));
        Assert.assertEquals((Object)new Long(-1L), (Object)ext.fromByteBuffer(ByteBufferUtil.bytes((long)-1L)));
        Assert.assertEquals((Object)new Long(Long.MIN_VALUE), (Object)ext.fromByteBuffer(ByteBufferUtil.bytes((long)Long.MIN_VALUE)));
        Assert.assertEquals((Object)new Long(Long.MAX_VALUE), (Object)ext.fromByteBuffer(ByteBufferUtil.bytes((long)Long.MAX_VALUE)));
    }

    private void test(Long number) {
        Assert.assertEquals((Object)number, (Object)ext.fromByteBuffer(ext.toByteBuffer(number)));
        if (number != null) {
            ByteBuffer b = ByteBuffer.allocate(8);
            b.putLong(number);
            b.rewind();
            Assert.assertEquals((Object)number, (Object)ext.fromByteBuffer(b));
        }
    }
}

