/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.serializers;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import me.prettyprint.cassandra.serializers.ObjectSerializer;
import me.prettyprint.hector.api.exceptions.HectorSerializationException;
import org.junit.Assert;
import org.junit.Test;

public class ObjectSerializerTest {
    @Test
    public void testConversions() {
        this.test(new SampleObject());
        this.test("Test string");
        this.test(Integer.MAX_VALUE);
        this.test(Long.MIN_VALUE);
        this.test(null);
    }

    @Test
    public void testEmptyByteArray_shouldReturnNull() {
        ObjectSerializer ser = ObjectSerializer.get();
        Assert.assertNull((String)"An empty byte array should be translated to null", (Object)ser.fromByteBuffer(ByteBuffer.wrap(new byte[0])));
    }

    @Test(expected=HectorSerializationException.class)
    public void testMalformedObject_shouldThrow() {
        ObjectSerializer ser = ObjectSerializer.get();
        ser.fromByteBuffer(ByteBuffer.wrap(new byte[]{1, 2, 3}));
    }

    @Test
    public void testCustomClassLoader() throws Exception {
        Object sampleObjectOtherCl;
        ObjectSerializer ser;
        Object deserialized;
        Constructor<?>[] declaredConstructors;
        ClassLoader bootstrapClassLoader = ClassLoader.getSystemClassLoader().getParent();
        URLClassLoader thisClassLoader = (URLClassLoader)SampleObject.class.getClassLoader();
        URLClassLoader customClassLoader = new URLClassLoader(thisClassLoader.getURLs(), bootstrapClassLoader);
        Class<?> sampleObjectClassOtherClassLoader = customClassLoader.loadClass(SampleObject.class.getName());
        Constructor<?> constructor = null;
        for (Constructor<?> con : declaredConstructors = sampleObjectClassOtherClassLoader.getDeclaredConstructors()) {
            if (con.getParameterTypes().length != 0) continue;
            con.setAccessible(true);
            constructor = con;
            break;
        }
        Assert.assertFalse(((deserialized = (ser = new ObjectSerializer((ClassLoader)customClassLoader)).fromByteBuffer(ser.toByteBuffer(sampleObjectOtherCl = constructor.newInstance(new Object[0])))).getClass() == SampleObject.class ? 1 : 0) != 0);
        Assert.assertTrue((deserialized.getClass() == sampleObjectClassOtherClassLoader ? 1 : 0) != 0);
        Assert.assertEquals(sampleObjectOtherCl, (Object)deserialized);
    }

    private void test(Object object) {
        ObjectSerializer ser = ObjectSerializer.get();
        Assert.assertEquals((Object)object, (Object)ser.fromByteBuffer(ser.toByteBuffer(object)));
    }

    private static class SampleObject
    implements Serializable {
        private final String a = "test";
        private final List<Void> b = new ArrayList<Void>();
        private final Calendar c = Calendar.getInstance();

        private SampleObject() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ("test" == null ? 0 : "test".hashCode());
            result = 31 * result + (this.b == null ? 0 : ((Object)this.b).hashCode());
            result = 31 * result + (this.c == null ? 0 : this.c.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SampleObject other = (SampleObject)obj;
            if ("test" == null ? other.a != null : !"test".equals(other.a)) {
                return false;
            }
            if (this.b == null ? other.b != null : !((Object)this.b).equals(other.b)) {
                return false;
            }
            return !(this.c == null ? other.c != null : !this.c.equals(other.c));
        }
    }
}

